/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.packet;

import com.creativemd.creativecore.common.utils.stack.StackInfo;
import com.creativemd.creativecore.common.utils.string.StringUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class CreativeCorePacket {
    public static final HashMap<String, Class<? extends CreativeCorePacket>> packets = new HashMap();

    public static void registerPacket(Class<? extends CreativeCorePacket> PacketClass, String id) {
        packets.put(id, PacketClass);
    }

    public static Class<? extends CreativeCorePacket> getClassByID(String id) {
        return packets.get(id);
    }

    public static String getIDByClass(Class<? extends CreativeCorePacket> packet) {
        for (Map.Entry<String, Class<? extends CreativeCorePacket>> entry : packets.entrySet()) {
            if (entry.getValue() != packet) continue;
            return entry.getKey();
        }
        return "";
    }

    public static String getIDByClass(CreativeCorePacket packet) {
        return CreativeCorePacket.getIDByClass(packet.getClass());
    }

    public abstract void writeBytes(ByteBuf var1);

    public abstract void readBytes(ByteBuf var1);

    @SideOnly(value=Side.CLIENT)
    public abstract void executeClient(EntityPlayer var1);

    public abstract void executeServer(EntityPlayer var1);

    public static void writeString(ByteBuf buf, String input) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)input);
    }

    public static String readString(ByteBuf buf) {
        return ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static void writePos(ByteBuf buf, BlockPos pos) {
        buf.writeInt(pos.func_177958_n());
        buf.writeInt(pos.func_177956_o());
        buf.writeInt(pos.func_177952_p());
    }

    public static BlockPos readPos(ByteBuf buf) {
        return new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void writeNBT(ByteBuf buf, NBTTagCompound nbt) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    public static NBTTagCompound readNBT(ByteBuf buf) {
        return ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static void writeVec3(Vec3d vec, ByteBuf buf) {
        buf.writeDouble(vec.field_72450_a);
        buf.writeDouble(vec.field_72448_b);
        buf.writeDouble(vec.field_72449_c);
    }

    public static Vec3d readVec3(ByteBuf buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return new Vec3d(x, y, z);
    }

    public static void writeStackInfo(ByteBuf buf, StackInfo info) {
        CreativeCorePacket.writeString(buf, StringUtils.ObjectsToString(info));
    }

    public static StackInfo readStackInfo(ByteBuf buf) {
        Object[] objects = StringUtils.StringToObjects(CreativeCorePacket.readString(buf));
        if (objects.length == 1 && objects[0] instanceof StackInfo) {
            return (StackInfo)objects[0];
        }
        return null;
    }

    public void writeStackInfos(ByteBuf buf, ArrayList<StackInfo> infos) {
        buf.writeInt(infos.size());
        for (int i = 0; i < infos.size(); ++i) {
            CreativeCorePacket.writeStackInfo(buf, infos.get(i));
        }
    }

    public ArrayList<StackInfo> readStackInfos(ByteBuf buf) {
        int count = buf.readInt();
        ArrayList<StackInfo> infos = new ArrayList<StackInfo>();
        for (int i = 0; i < count; ++i) {
            StackInfo info = CreativeCorePacket.readStackInfo(buf);
            if (info == null) continue;
            infos.add(info);
        }
        return infos;
    }

    public static void writeItemStack(ByteBuf buf, ItemStack stack) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
    }

    public static ItemStack readItemStack(ByteBuf buf) {
        return ByteBufUtils.readItemStack((ByteBuf)buf);
    }
}

