/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.stack;

import com.creativemd.creativecore.common.utils.stack.IStackLoader;
import com.creativemd.creativecore.common.utils.stack.StackInfo;
import com.creativemd.creativecore.common.utils.stack.StackInfoBlock;
import com.creativemd.creativecore.common.utils.stack.StackInfoItemStack;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class StackInfoMaterial
extends StackInfo
implements IStackLoader {
    public Material material;

    public StackInfoMaterial(Material material, int stackSize) {
        super(stackSize);
        this.material = material;
    }

    public StackInfoMaterial(Material material) {
        this(material, 0);
    }

    @Override
    public StackInfo getStackInfo(Object item) {
        if (item instanceof Material) {
            return new StackInfoMaterial((Material)item);
        }
        return null;
    }

    @Override
    public StackInfo getStackInfoFromString(String input) {
        Block block = Block.func_149684_b((String)input);
        if (block != null) {
            return new StackInfoMaterial(block.func_149688_o(null));
        }
        return null;
    }

    @Override
    public String toString() {
        for (Object name : Block.field_149771_c.func_148742_b()) {
            Block block = Block.func_149684_b((String)((String)name));
            if (block == null || block.func_149688_o(null) != this.material) continue;
            return (String)name;
        }
        return null;
    }

    @Override
    protected boolean isStackInstanceIgnoreSize(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block != null) {
            return block.func_149688_o(null) == this.material;
        }
        return false;
    }

    @Override
    public boolean isInstanceIgnoreSize(StackInfo info) {
        Block block;
        if (info instanceof StackInfoMaterial) {
            return ((StackInfoMaterial)info).material == this.material;
        }
        if (info instanceof StackInfoBlock) {
            return ((StackInfoBlock)info).block.func_149688_o(null) == this.material;
        }
        if (info instanceof StackInfoItemStack && (block = Block.func_149634_a((Item)((StackInfoItemStack)info).stack.func_77973_b())) != null) {
            return block.func_149688_o(null) == this.material;
        }
        return false;
    }

    @Override
    public ItemStack getItemStack(int stacksize) {
        for (Object name : Block.field_149771_c.func_148742_b()) {
            Block block = Block.func_149684_b((String)((String)name));
            if (block == null || block.func_149688_o(null) != this.material) continue;
            return new ItemStack(block, stacksize);
        }
        return null;
    }

    @Override
    public boolean equalsIgnoreSize(Object object) {
        return object instanceof StackInfoMaterial && ((StackInfoMaterial)object).material == this.material;
    }

    @Override
    public StackInfo copy() {
        return new StackInfoMaterial(this.material, this.stackSize);
    }

    @Override
    public String toTitle() {
        return this.material.toString();
    }
}

