/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.gui.core;

import com.creativemd.creativecore.gui.core.GuiControl;
import com.creativemd.creativecore.gui.core.container.IControlParent;

public abstract class CoreControl {
    public CoreControl parent;
    public String name;
    public boolean enabled;
    private int id = -1;

    public void setID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public CoreControl(String name) {
        this.name = name;
        this.enabled = true;
    }

    public CoreControl setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean is(String name) {
        return this.name.equalsIgnoreCase(name);
    }

    public boolean isParentContainer() {
        return this.parent instanceof IControlParent;
    }

    public IControlParent getParentContainer() {
        if (this.isParentContainer()) {
            return (IControlParent)((Object)this.parent);
        }
        return null;
    }

    public boolean isInteractable() {
        return this.enabled;
    }

    public void moveControlAbove(GuiControl controlInBack) {
        if (this.isParentContainer()) {
            this.getParentContainer().moveControlAbove(this, controlInBack);
        }
    }

    public void moveControlBehind(GuiControl controlInFront) {
        if (this.isParentContainer()) {
            this.getParentContainer().moveControlBehind(this, controlInFront);
        }
    }

    public void moveControlToBottom() {
        if (this.isParentContainer()) {
            this.getParentContainer().moveControlToBottom(this);
        }
    }

    public void moveControlToTop() {
        if (this.isParentContainer()) {
            this.getParentContainer().moveControlToTop(this);
        }
    }
}

