/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.gui.core;

import com.creativemd.creativecore.gui.client.style.Style;
import com.creativemd.creativecore.gui.core.CoreControl;
import com.creativemd.creativecore.gui.core.GuiRenderHelper;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiControl
extends CoreControl {
    public static Style defaultStyle = Style.liteStyle;
    public int posX;
    public int posY;
    public int width;
    public int height;
    public float rotation;
    public boolean visible;
    protected Style style = null;
    protected int borderWidth = 1;
    protected int marginWidth = 2;

    public GuiControl(String name, int x, int y, int width, int height) {
        super(name);
        this.posX = x;
        this.posY = y;
        this.width = width;
        this.height = height;
        this.rotation = 0.0f;
        this.visible = true;
    }

    public GuiControl setRotation(float rotation) {
        this.rotation = rotation;
        return this;
    }

    public GuiControl setStyle(Style style) {
        this.style = style;
        return this;
    }

    @Override
    public boolean isInteractable() {
        return super.isInteractable() && this.visible;
    }

    public boolean isMouseOver() {
        return false;
    }

    protected boolean isMouseOver(int posX, int posY) {
        return posX >= this.posX && posX < this.posX + this.width && posY >= this.posY && posY < this.posY + this.height;
    }

    public GuiControl getParent() {
        return (GuiControl)this.parent;
    }

    public Style getStyle() {
        if (this.style != null) {
            return this.style;
        }
        if (this.parent != null) {
            return this.getParent().getStyle();
        }
        return defaultStyle;
    }

    public ArrayList<String> getTooltip() {
        return new ArrayList<String>();
    }

    public Vec3d getCenterOffset() {
        return new Vec3d((double)(this.width / 2), (double)(this.height / 2), 0.0);
    }

    protected abstract void renderContent(GuiRenderHelper var1, Style var2, int var3, int var4);

    protected void renderBackground(GuiRenderHelper helper, Style style) {
        style.getBorder(this).renderStyle(helper, this.width, this.height);
        GlStateManager.func_179109_b((float)this.borderWidth, (float)this.borderWidth, (float)0.0f);
        style.getBackground(this).renderStyle(helper, this.width - this.borderWidth * 2, this.height - this.borderWidth * 2);
    }

    protected void renderForeground(GuiRenderHelper helper, Style style) {
        if (this.enabled) {
            style.getDisableEffect(this).renderStyle(helper, this.width, this.height);
        }
    }

    protected void renderControl(GuiRenderHelper helper) {
        if (!this.visible) {
            return;
        }
        Style style = this.getStyle();
        Vec3d centerOffset = this.getCenterOffset();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)this.posX + centerOffset.field_72450_a), (double)((double)this.posY + centerOffset.field_72448_b), (double)0.0);
        GlStateManager.func_179114_b((float)this.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(-centerOffset.field_72450_a), (double)(-centerOffset.field_72448_b), (double)0.0);
        this.renderBackground(helper, style);
        int spaceUsed = this.borderWidth + this.marginWidth;
        GlStateManager.func_179109_b((float)this.marginWidth, (float)this.marginWidth, (float)0.0f);
        this.renderContent(helper, style, this.width - spaceUsed * 2, this.height - spaceUsed * 2);
        GlStateManager.func_179109_b((float)(-spaceUsed), (float)(-spaceUsed), (float)0.0f);
        this.renderForeground(helper, style);
        GlStateManager.func_179121_F();
    }

    public boolean mouseScrolled(int posX, int posY, int scrolled) {
        return false;
    }

    public boolean mousePressed(int posX, int posY, int button) {
        return false;
    }

    public boolean mouseDragged(int posX, int posY, int button, long time) {
        return false;
    }

    public void mouseReleased(int posX, int posY, int button) {
    }

    public void mouseMove(int posX, int posY, int button) {
    }

    public boolean onKeyPressed(char character, int key) {
        return false;
    }
}

