/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.client.mods.optifine;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class OptifineHelper {
    private static boolean active = FMLClientHandler.instance().hasOptifine();
    private static Minecraft mc = Minecraft.func_71410_x();
    private static ThreadLocal<Object> renderEnv;
    private static boolean loadedOptifineReflections;
    private static Method getCustomizedQuads;
    private static Method getCustomizedModel;
    private static Class renderEnvClass;
    private static Class blockModelCustomizer;
    private static Constructor<?> renderEnvConstructor;
    private static Method resetEnv;
    private static Method getColorMultiplier;
    private static Field isEmissive;
    private static Method getQuadEmissive;
    private static Method isShadersMethod;
    private static Method isRenderRegions;
    private static Field regionX;
    private static Field regionZ;

    private static void loadOptifineReflections() {
        try {
            loadedOptifineReflections = true;
            renderEnvClass = Class.forName("net.optifine.render.RenderEnv");
            renderEnvConstructor = renderEnvClass.getConstructor(IBlockAccess.class, IBlockState.class, BlockPos.class);
            resetEnv = ReflectionHelper.findMethod((Class)renderEnvClass, (String)"reset", (String)"reset", (Class[])new Class[]{IBlockAccess.class, IBlockState.class, BlockPos.class});
            blockModelCustomizer = Class.forName("net.optifine.model.BlockModelCustomizer");
            getCustomizedModel = ReflectionHelper.findMethod((Class)blockModelCustomizer, (String)"getRenderModel", (String)"getRenderModel", (Class[])new Class[]{IBakedModel.class, IBlockState.class, renderEnvClass});
            getCustomizedQuads = ReflectionHelper.findMethod((Class)blockModelCustomizer, (String)"getRenderQuads", (String)"getRenderQuads", (Class[])new Class[]{List.class, IBlockAccess.class, IBlockState.class, BlockPos.class, EnumFacing.class, BlockRenderLayer.class, Long.TYPE, renderEnvClass});
            Class<?> customColorsClass = Class.forName("net.optifine.CustomColors");
            getColorMultiplier = ReflectionHelper.findMethod(customColorsClass, (String)"getColorMultiplier", (String)"getColorMultiplier", (Class[])new Class[]{BakedQuad.class, IBlockState.class, IBlockAccess.class, BlockPos.class, renderEnvClass});
            renderEnv = ThreadLocal.withInitial(new Supplier<Object>(){

                @Override
                public Object get() {
                    try {
                        return renderEnvConstructor.newInstance(null, null, null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            Class<?> configClass = Class.forName("Config");
            isShadersMethod = configClass.getMethod("isShaders", new Class[0]);
            isRenderRegions = configClass.getMethod("isRenderRegions", new Class[0]);
            regionX = ReflectionHelper.findField(RenderChunk.class, (String[])new String[]{"regionX"});
            regionZ = ReflectionHelper.findField(RenderChunk.class, (String[])new String[]{"regionZ"});
            isEmissive = ReflectionHelper.findField(TextureAtlasSprite.class, (String[])new String[]{"isEmissive"});
            getQuadEmissive = ReflectionHelper.findMethod(BakedQuad.class, (String)"getQuadEmissive", (String)"getQuadEmissive", (Class[])new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            active = false;
            e.printStackTrace();
        }
    }

    public static IBakedModel getRenderModel(IBakedModel model, IBlockAccess world, IBlockState state, BlockPos pos) {
        if (!active) {
            return model;
        }
        try {
            return (IBakedModel)getCustomizedModel.invoke(null, model, state, OptifineHelper.getEnv(world, state, pos));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static Object getEnv(IBlockAccess world, IBlockState state, BlockPos pos) {
        try {
            Object env = renderEnv.get();
            resetEnv.invoke(env, world, state, pos);
            return env;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static List<BakedQuad> getRenderQuads(List<BakedQuad> quads, IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing, BlockRenderLayer layer, long rand) {
        if (!active || world == null || layer == null) {
            return quads;
        }
        try {
            quads = (List)getCustomizedQuads.invoke(null, quads, world, state, pos, facing, layer, rand, OptifineHelper.getEnv(world, state, pos));
            int size = quads.size();
            for (int i = 0; i < size; ++i) {
                BakedQuad emissive = (BakedQuad)getQuadEmissive.invoke(quads.get(i), new Object[0]);
                if (emissive == null) continue;
                quads.add(emissive);
            }
            return quads;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static int getColorMultiplier(BakedQuad quad, IBlockState state, IBlockAccess world, BlockPos pos) {
        try {
            return (Integer)getColorMultiplier.invoke(null, quad, state, world, pos, OptifineHelper.getEnv(world, state, pos));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static boolean isShaders() {
        try {
            return (Boolean)isShadersMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isRenderRegions() {
        try {
            return (Boolean)isRenderRegions.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int getRenderChunkRegionX(RenderChunk chunk) {
        try {
            return regionX.getInt(chunk);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int getRenderChunkRegionZ(RenderChunk chunk) {
        try {
            return regionZ.getInt(chunk);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static boolean isEmissive(TextureAtlasSprite sprite) {
        if (!active) {
            return false;
        }
        try {
            return isEmissive.getBoolean(sprite);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static BakedQuad getQuadEmissive(BakedQuad quad) {
        if (!active) {
            return quad;
        }
        try {
            BakedQuad emissive = (BakedQuad)getQuadEmissive.invoke((Object)quad, new Object[0]);
            if (emissive != null) {
                return emissive;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return quad;
    }

    static {
        loadedOptifineReflections = false;
        isShadersMethod = null;
        isRenderRegions = null;
        if (active) {
            OptifineHelper.loadOptifineReflections();
        }
    }
}

