/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.recipe;

import com.creativemd.creativecore.common.recipe.IRecipeInfo;
import com.creativemd.creativecore.common.utils.stack.InfoStack;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BetterShapedRecipe
implements IRecipe,
IRecipeInfo {
    public InfoStack[] info;
    public ItemStack output;
    public int width;
    public int height;

    public BetterShapedRecipe(int width, InfoStack[] info, ItemStack output) {
        this.info = info;
        this.output = output;
        this.width = width;
        this.height = this.info.length / this.width;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                InfoStack target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.info[this.width - subX - 1 + subY * this.width] : this.info[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target == null && !slot.func_190926_b()) {
                    return false;
                }
                if (target != null && slot.func_190926_b()) {
                    return false;
                }
                if (target == null || slot.func_190926_b() || target.isInstanceIgnoreSize(slot)) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting inventory) {
        return this.output.func_77946_l();
    }

    public int func_77570_a() {
        return this.width * this.height;
    }

    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    public ItemStack[] getInput() {
        ItemStack[] stacks = new ItemStack[this.info.length];
        for (int i = 0; i < stacks.length; ++i) {
            if (this.info[i] == null) continue;
            stacks[i] = this.info[i].getItemStack();
        }
        return stacks;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return nonnulllist;
    }
}

