/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.recipe;

import com.creativemd.creativecore.common.utils.stack.InfoStack;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class Recipe {
    public ItemStack[] output;
    public InfoStack[] input;

    public Recipe(ItemStack output, Object ... input) {
        this(new ItemStack[]{output}, input);
    }

    public Recipe(ItemStack[] output, InfoStack[] info) {
        this.output = output;
        this.input = info;
    }

    public Recipe(ItemStack[] output, Object ... input) {
        ArrayList<InfoStack> info = new ArrayList<InfoStack>();
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == null) continue;
            if (input[i] instanceof InfoStack) {
                info.add((InfoStack)input[i]);
                continue;
            }
            InfoStack infoStack = InfoStack.parseObject(input[i]);
            if (infoStack == null) continue;
            info.add(infoStack);
        }
        this.output = output;
        this.input = info.toArray(new InfoStack[0]);
    }

    public ItemStack[] getInputStacks() {
        ItemStack[] stacks = new ItemStack[this.input.length];
        for (int i = 0; i < stacks.length; ++i) {
            if (this.input[i] == null) continue;
            stacks[i] = this.input[i].getItemStack();
        }
        return stacks;
    }

    public void consumeRecipe(IInventory inventory) {
        this.consumeRecipe(inventory, 1);
    }

    public void consumeRecipe(IInventory inventory, int amount) {
        ArrayList<InfoStack> info = new ArrayList<InfoStack>(Arrays.asList(this.input));
        block0: for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            for (int j = 0; j < info.size(); ++j) {
                if (!info.get(j).isInstance(stack)) continue;
                stack.func_190918_g(info.get((int)j).stackSize * amount);
                if (stack.func_190926_b()) {
                    inventory.func_70299_a(i, ItemStack.field_190927_a);
                }
                info.remove(j);
                continue block0;
            }
        }
    }

    public ItemStack[] getCraftingResult(IInventory inventory) {
        return this.output;
    }

    public int getNumberofResults(IInventory inventory) {
        int limit = 1;
        ArrayList<InfoStack> info = new ArrayList<InfoStack>(Arrays.asList(this.input));
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            boolean found = false;
            for (int j = 0; j < info.size(); ++j) {
                if (!info.get(i).isInstance(stack)) continue;
                limit = Math.min(limit, info.get(i).getAmount(stack));
                found = true;
                info.remove(j);
                break;
            }
            if (found) continue;
            return 0;
        }
        return info.size() == 0 ? limit : 0;
    }

    public boolean isValidRecipe(IInventory inventory) {
        ArrayList<InfoStack> info = new ArrayList<InfoStack>(Arrays.asList(this.input));
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            boolean found = false;
            for (int j = 0; j < info.size(); ++j) {
                if (!info.get(j).isInstance(stack)) continue;
                found = true;
                info.remove(j);
                break;
            }
            if (found) continue;
            return false;
        }
        return info.size() == 0;
    }

    public static int indexOf(IInventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) != stack) continue;
            return i;
        }
        return -1;
    }
}

