/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.box;

import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.creativecore.common.utils.math.box.BoxUtils;
import com.creativemd.creativecore.common.utils.math.box.CreativeAxisAlignedBB;
import com.creativemd.creativecore.common.utils.math.box.OrientatedBoundingBox;
import com.creativemd.creativecore.common.utils.math.vec.MatrixUtils;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class CollidingPlane {
    public final CreativeAxisAlignedBB bb;
    public final EnumFacing facing;
    public final PlaneCache cache;
    protected final Vector3d origin;
    protected final Vector3d normal;
    public static final int accuracySteps = 10;

    public CollidingPlane(CreativeAxisAlignedBB bb, EnumFacing facing, PlaneCache cache, Vector3d[] corners, BoxUtils.BoxCorner[] planeCorners) {
        this.bb = bb;
        this.facing = facing;
        this.cache = cache;
        this.origin = corners[planeCorners[0].ordinal()];
        Vector3d first = corners[planeCorners[1].ordinal()];
        Vector3d second = corners[planeCorners[2].ordinal()];
        this.normal = new Vector3d((first.y - this.origin.y) * (second.z - this.origin.z) - (first.z - this.origin.z) * (second.y - this.origin.y), (first.z - this.origin.z) * (second.x - this.origin.x) - (first.x - this.origin.x) * (second.z - this.origin.z), (first.x - this.origin.x) * (second.y - this.origin.y) - (first.y - this.origin.y) * (second.x - this.origin.x));
    }

    public Boolean isInFront(Vector3d vec) {
        double scalar = (vec.x - this.origin.x) * this.normal.x + (vec.y - this.origin.y) * this.normal.y + (vec.z - this.origin.z) * this.normal.z;
        if (scalar > 0.0) {
            return true;
        }
        if (scalar < 0.0) {
            return false;
        }
        return null;
    }

    public Double binarySearch(@Nullable Double value, AxisAlignedBB toCheck, double checkRadiusSquared, Vector3d center, MatrixUtils.MatrixLookupTable table) {
        if (table.isSimple) {
            Double t = this.searchBetweenSimple(value, toCheck, center, new Vector3d(center), new Vector3d(), 0.0, 1.0, table, 0);
            if (t != null && this.intersects(toCheck, checkRadiusSquared, center, t, table)) {
                return t;
            }
            return null;
        }
        if (table.hasOneRotation && !table.hasTranslation) {
            Vector3d start = new Vector3d(center);
            Vector3d temp = new Vector3d();
            int halfRotations = table.getNumberOfHalfRotations();
            double halfRotationSize = 1.0 / (double)halfRotations;
            Double t = this.searchBetweenSimple(value, toCheck, center, start, temp, 0.0, halfRotationSize, table, 0);
            if (t != null && this.intersects(toCheck, checkRadiusSquared, center, t, table)) {
                return t;
            }
            start.set((Tuple3d)center);
            table.transformInverted(start, halfRotationSize);
            t = this.searchBetweenSimple(value, toCheck, center, new Vector3d(center), temp, halfRotationSize, halfRotationSize * 2.0, table, 0);
            if (t != null && this.intersects(toCheck, checkRadiusSquared, center, t, table)) {
                return t;
            }
            return null;
        }
        Vector3d start = new Vector3d(center);
        Vector3d temp = new Vector3d();
        int halfRotations = table.getNumberOfHalfRotations();
        double halfRotationSize = 1.0 / (double)halfRotations;
        for (int i = 0; i < halfRotations; ++i) {
            double startT = halfRotationSize * (double)i;
            double endT = halfRotationSize * (double)(i + 1);
            if (startT != 0.0) {
                start.set((Tuple3d)center);
                table.transformInverted(start, startT);
            }
            if (value <= startT) {
                return null;
            }
            Double t = this.searchBetweenSimple(value, toCheck, center, start, temp, startT, endT, table, 0);
            if (t == null || !this.intersects(toCheck, checkRadiusSquared, center, t, table)) continue;
            return t;
        }
        return null;
    }

    protected Double searchBetweenSimple(@Nullable Double value, AxisAlignedBB toCheck, Vector3d center, Vector3d start, Vector3d temp, double startT, double endT, MatrixUtils.MatrixLookupTable table, int steps) {
        if (value != null && value < startT) {
            return null;
        }
        Boolean beforeFront = this.isInFront(start);
        if (beforeFront == null) {
            return startT;
        }
        temp.set((Tuple3d)center);
        table.transformInverted(temp, endT);
        Boolean afterFront = this.isInFront(temp);
        if (afterFront == null) {
            return endT;
        }
        if (beforeFront != afterFront) {
            if (steps < 10) {
                ++steps;
                double halfT = (startT + endT) / 2.0;
                temp.set((Tuple3d)center);
                table.transformInverted(temp, halfT);
                Boolean halfFront = this.isInFront(temp);
                if (halfFront == null) {
                    return halfT;
                }
                if (beforeFront != halfFront) {
                    return this.searchBetweenSimple(value, toCheck, center, start, temp, startT, halfT, table, steps);
                }
                return this.searchBetweenSimple(value, toCheck, center, temp, start, halfT, endT, table, steps);
            }
            return startT;
        }
        return null;
    }

    public boolean intersects(AxisAlignedBB toCheck, double checkRadiusSquared, Vector3d center, double t, MatrixUtils.MatrixLookupTable table) {
        if (this.bb.contains(center)) {
            return true;
        }
        Vector3d temp = new Vector3d(center);
        temp.sub((Tuple3d)this.cache.center);
        if (temp.lengthSquared() >= checkRadiusSquared + this.cache.radiusSquared) {
            return false;
        }
        Matrix4d matrix = table.getInverted(t);
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        for (int i = 0; i < BoxUtils.BoxCorner.values().length; ++i) {
            Vector3d corner = BoxUtils.BoxCorner.values()[i].getVector(toCheck);
            corner.sub((Tuple3d)table.origin.translation());
            corner.sub((Tuple3d)table.rotationCenter);
            table.origin.rotationInv().transform((Tuple3d)corner);
            corner.add((Tuple3d)table.rotationCenter);
            MatrixUtils.MatrixLookupTable.transform(matrix, table.rotationCenter, corner);
            if (this.bb.contains(corner)) {
                return true;
            }
            minX = Math.min(minX, corner.x);
            minY = Math.min(minY, corner.y);
            minZ = Math.min(minZ, corner.z);
            maxX = Math.max(maxX, corner.x);
            maxY = Math.max(maxY, corner.y);
            maxZ = Math.max(maxZ, corner.z);
        }
        return this.bb.field_72340_a < maxX && this.bb.field_72336_d > minX && this.bb.field_72338_b < maxY && this.bb.field_72337_e > minY && this.bb.field_72339_c < maxZ && this.bb.field_72334_f > minZ;
    }

    public static CollidingPlane[] getPlanes(CreativeAxisAlignedBB box, PlaneCache cache, MatrixUtils.MatrixLookupTable table) {
        boolean north;
        Vector3d[] corners = BoxUtils.getCorners(box);
        boolean east = table.x > 0.0;
        boolean west = table.x < 0.0;
        boolean up = table.y > 0.0;
        boolean down = table.y < 0.0;
        boolean south = table.z > 0.0;
        boolean bl = north = table.z < 0.0;
        if (table.hasRotY || table.hasRotZ) {
            west = true;
            east = true;
        }
        if (table.hasRotX || table.hasRotZ) {
            down = true;
            up = true;
        }
        if (table.hasRotX || table.hasRotY) {
            north = true;
            south = true;
        }
        CollidingPlane[] planes = new CollidingPlane[BooleanUtils.countTrue(east, west, up, down, south, north)];
        int index = 0;
        if (east) {
            planes[index] = new CollidingPlane(box, EnumFacing.EAST, cache, corners, BoxUtils.BoxFace.getFace((EnumFacing)EnumFacing.EAST).corners);
            ++index;
        }
        if (west) {
            planes[index] = new CollidingPlane(box, EnumFacing.WEST, cache, corners, BoxUtils.BoxFace.getFace((EnumFacing)EnumFacing.WEST).corners);
            ++index;
        }
        if (up) {
            planes[index] = new CollidingPlane(box, EnumFacing.UP, cache, corners, BoxUtils.BoxFace.getFace((EnumFacing)EnumFacing.UP).corners);
            ++index;
        }
        if (down) {
            planes[index] = new CollidingPlane(box, EnumFacing.DOWN, cache, corners, BoxUtils.BoxFace.getFace((EnumFacing)EnumFacing.DOWN).corners);
            ++index;
        }
        if (south) {
            planes[index] = new CollidingPlane(box, EnumFacing.SOUTH, cache, corners, BoxUtils.BoxFace.getFace((EnumFacing)EnumFacing.SOUTH).corners);
            ++index;
        }
        if (north) {
            planes[index] = new CollidingPlane(box, EnumFacing.NORTH, cache, corners, BoxUtils.BoxFace.getFace((EnumFacing)EnumFacing.NORTH).corners);
            ++index;
        }
        return planes;
    }

    public static EnumFacing getDirection(OrientatedBoundingBox box, CollidingPlane[] planes, Vector3d center) {
        if (box.contains(center)) {
            return null;
        }
        Boolean positiveX = null;
        Boolean positiveY = null;
        Boolean positiveZ = null;
        block5: for (CollidingPlane plane : planes) {
            Boolean result = plane.isInFront(center);
            if (result != null && !result.booleanValue()) continue;
            switch (plane.facing.func_176740_k()) {
                case X: {
                    positiveX = plane.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                    continue block5;
                }
                case Y: {
                    positiveY = plane.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                    continue block5;
                }
                case Z: {
                    positiveZ = plane.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                    continue block5;
                }
                default: {
                    throw new InternalError("1 + 1 = 3");
                }
            }
        }
        if (positiveX == null && positiveY == null && positiveZ == null) {
            return null;
        }
        if (positiveY == null && positiveZ == null) {
            return positiveX == null ? null : (positiveX != false ? EnumFacing.EAST : EnumFacing.WEST);
        }
        if (positiveX == null && positiveZ == null) {
            return positiveY == null ? null : (positiveY != false ? EnumFacing.UP : EnumFacing.DOWN);
        }
        if (positiveX == null && positiveY == null) {
            return positiveZ == null ? null : (positiveZ != false ? EnumFacing.SOUTH : EnumFacing.NORTH);
        }
        Vector3d relative = new Vector3d(center);
        relative.sub((Tuple3d)box.cache.center);
        Vector3d size = box.getSize3d();
        size.normalize();
        relative.x *= size.x;
        relative.y *= size.y;
        relative.z *= size.z;
        if (positiveX != null && positiveY != null && positiveZ != null) {
            if (Math.abs(relative.x) > Math.abs(relative.y)) {
                if (Math.abs(relative.x) > Math.abs(relative.z)) {
                    return positiveX != false ? EnumFacing.EAST : EnumFacing.WEST;
                }
                return positiveZ != false ? EnumFacing.SOUTH : EnumFacing.NORTH;
            }
            if (Math.abs(relative.y) > Math.abs(relative.z)) {
                return positiveY != false ? EnumFacing.UP : EnumFacing.DOWN;
            }
            return positiveZ != false ? EnumFacing.SOUTH : EnumFacing.NORTH;
        }
        if (positiveX != null && positiveY != null) {
            if (Math.abs(relative.x) > Math.abs(relative.y)) {
                return positiveX != false ? EnumFacing.EAST : EnumFacing.WEST;
            }
            return positiveY != false ? EnumFacing.UP : EnumFacing.DOWN;
        }
        if (positiveY != null && positiveZ != null) {
            if (Math.abs(relative.y) > Math.abs(relative.z)) {
                return positiveY != false ? EnumFacing.UP : EnumFacing.DOWN;
            }
            return positiveZ != false ? EnumFacing.SOUTH : EnumFacing.NORTH;
        }
        if (positiveX != null && positiveZ != null) {
            if (Math.abs(relative.x) > Math.abs(relative.z)) {
                return positiveX != false ? EnumFacing.EAST : EnumFacing.WEST;
            }
            return positiveZ != false ? EnumFacing.SOUTH : EnumFacing.NORTH;
        }
        throw new InternalError("Math has failed: 1 != 1");
    }

    public static class PushCache {
        public OrientatedBoundingBox pushBox;
        public EnumFacing facing;
        public AxisAlignedBB entityBox;
    }

    public static class PlaneCache {
        public CollidingPlane[] planes;
        public final Vector3d center;
        public final double radiusSquared;

        public PlaneCache(AxisAlignedBB box) {
            this.radiusSquared = (box.field_72340_a * box.field_72336_d + box.field_72338_b * box.field_72337_e + box.field_72339_c * box.field_72334_f) * 0.5;
            this.center = new Vector3d(box.field_72340_a + (box.field_72336_d - box.field_72340_a) * 0.5, box.field_72338_b + (box.field_72337_e - box.field_72338_b) * 0.5, box.field_72339_c + (box.field_72334_f - box.field_72339_c) * 0.5);
        }

        public boolean isCached() {
            return this.planes != null;
        }

        public void reset() {
            this.planes = null;
        }
    }
}

