/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.mc;

import com.creativemd.creativecore.common.utils.stack.InfoStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryUtils {
    public static NBTTagCompound saveInventoryBasic(IInventory basic) {
        ItemStack[] stacks = new ItemStack[basic.func_70302_i_()];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = basic.func_70301_a(i);
        }
        return InventoryUtils.saveInventory(stacks);
    }

    public static NBTTagCompound saveInventory(ItemStack[] inventory) {
        NBTTagCompound nbtInv = new NBTTagCompound();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i].func_190926_b()) continue;
            NBTTagCompound newNBT = new NBTTagCompound();
            inventory[i].func_77955_b(newNBT);
            nbtInv.func_74782_a("slot" + i, (NBTBase)newNBT);
        }
        nbtInv.func_74768_a("size", inventory.length);
        return nbtInv;
    }

    public static ItemStack[] loadInventory(NBTTagCompound nbt) {
        ItemStack[] inventory = new ItemStack[nbt.func_74762_e("size")];
        for (int i = 0; i < inventory.length; ++i) {
            inventory[i] = nbt.func_74764_b("slot" + i) ? new ItemStack(nbt.func_74775_l("slot" + i)) : ItemStack.field_190927_a;
        }
        return inventory;
    }

    public static InventoryBasic loadInventoryBasic(NBTTagCompound nbt) {
        return InventoryUtils.loadInventoryBasic(nbt, nbt.func_74762_e("size"));
    }

    public static InventoryBasic loadInventoryBasic(NBTTagCompound nbt, int length) {
        InventoryBasic basic = new InventoryBasic("basic", false, length);
        if (nbt != null) {
            ItemStack[] stacks = InventoryUtils.loadInventory(nbt);
            for (int i = 0; i < stacks.length; ++i) {
                if (length <= i) continue;
                basic.func_70299_a(i, stacks[i]);
            }
        }
        return basic;
    }

    public static boolean isItemStackEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA.func_190926_b() && stackB.func_190926_b()) {
            return true;
        }
        if (stackA.func_190926_b() || stackB.func_190926_b()) {
            return false;
        }
        if (stackA.func_77973_b() != stackB.func_77973_b()) {
            return false;
        }
        if (stackA.func_77952_i() != stackB.func_77952_i()) {
            return false;
        }
        if (!stackA.func_77942_o() && stackB.func_77942_o()) {
            return false;
        }
        return (!stackA.func_77942_o() || stackA.func_77978_p().equals((Object)stackB.func_77978_p())) && stackA.areCapsCompatible(stackB);
    }

    public static boolean consumeItemStack(IInventory inventory, ItemStack stack) {
        if (InventoryUtils.getAmount(inventory, stack) >= stack.func_190916_E()) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!InventoryUtils.isItemStackEqual(inventory.func_70301_a(i), stack)) continue;
                int amount = Math.min(stack.func_190916_E(), inventory.func_70301_a(i).func_190916_E());
                if (amount > 0) {
                    inventory.func_70301_a(i).func_190918_g(amount);
                    if (inventory.func_70301_a(i).func_190926_b()) {
                        inventory.func_70299_a(i, ItemStack.field_190927_a);
                    }
                    stack.func_190918_g(amount);
                }
                if (!stack.func_190926_b()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack) {
        int i;
        if (stack.func_190926_b()) {
            return true;
        }
        for (i = 0; i < inventory.length; ++i) {
            int amount;
            if (!InventoryUtils.isItemStackEqual(inventory[i], stack) || (amount = Math.min(stack.func_77976_d() - inventory[i].func_190916_E(), stack.func_190916_E())) <= 0) continue;
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190920_e(inventory[i].func_190916_E() + amount);
            inventory[i] = newStack;
            stack.func_190918_g(amount);
            if (!stack.func_190926_b()) continue;
            return true;
        }
        for (i = 0; i < inventory.length; ++i) {
            if (inventory[i] != null && !inventory[i].func_190926_b()) continue;
            inventory[i] = stack;
            return true;
        }
        return false;
    }

    public static boolean addItemStackToInventory(IInventory inventory, ItemStack stack) {
        int i;
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            int amount;
            if (!InventoryUtils.isItemStackEqual(inventory.func_70301_a(i), stack) || (amount = Math.min(stack.func_77976_d() - inventory.func_70301_a(i).func_190916_E(), stack.func_190916_E())) <= 0) continue;
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190920_e(inventory.func_70301_a(i).func_190916_E() + amount);
            inventory.func_70299_a(i, newStack);
            stack.func_190918_g(amount);
            if (!stack.func_190926_b()) continue;
            return true;
        }
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!inventory.func_70301_a(i).func_190926_b()) continue;
            inventory.func_70299_a(i, stack);
            return true;
        }
        return false;
    }

    public static int getAmount(IInventory inventory, ItemStack stack) {
        int amount = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!InventoryUtils.isItemStackEqual(inventory.func_70301_a(i), stack)) continue;
            amount += inventory.func_70301_a(i).func_190916_E();
        }
        return amount;
    }

    public static void cleanInventory(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || !stack.func_190926_b()) continue;
            inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public static int consumeInfoStack(InfoStack info, IInventory inventory) {
        return InventoryUtils.consumeInfoStack(info, inventory, null);
    }

    public static int consumeInfoStack(InfoStack info, IInventory inventory, ArrayList<ItemStack> consumed) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int stackSize = info.stackSize;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || !info.isInstanceIgnoreSize(stack)) continue;
            int used = Math.min(stackSize, stack.func_190916_E());
            stack.func_190918_g(used);
            ItemStack stackCopy = stack.func_77946_l();
            stackCopy.func_190920_e(used);
            stacks.add(stackCopy);
            if ((stackSize -= used) <= 0) break;
        }
        if (consumed != null) {
            consumed.addAll(stacks);
        }
        return stackSize;
    }

    public static void sortInventory(IInventory inventory, boolean alphabetical) {
        int i;
        ArrayList<ItemStack> sorting = new ArrayList<ItemStack>();
        for (int i2 = 0; i2 < inventory.func_70302_i_(); ++i2) {
            ItemStack stack = inventory.func_70301_a(i2);
            if (stack.func_190926_b()) continue;
            sorting.add(stack);
        }
        if (alphabetical) {
            Collections.sort(sorting, new Comparator<ItemStack>(){

                @Override
                public int compare(ItemStack arg0, ItemStack arg1) {
                    return arg0.func_82833_r().compareToIgnoreCase(arg1.func_82833_r());
                }
            });
        } else {
            Collections.sort(sorting, new Comparator<ItemStack>(){

                @Override
                public int compare(ItemStack arg0, ItemStack arg1) {
                    int id1;
                    int id0 = Item.func_150891_b((Item)arg0.func_77973_b());
                    if (id0 < (id1 = Item.func_150891_b((Item)arg1.func_77973_b()))) {
                        return -1;
                    }
                    if (id0 > id1) {
                        return 1;
                    }
                    if (arg0.func_77952_i() < arg1.func_77952_i()) {
                        return -1;
                    }
                    if (arg0.func_77952_i() > arg1.func_77952_i()) {
                        return 1;
                    }
                    return arg0.func_82833_r().compareToIgnoreCase(arg1.func_82833_r());
                }
            });
        }
        int maxStackSize = inventory.func_70297_j_();
        for (i = 0; i < sorting.size() - 1; ++i) {
            int maxStack;
            int use;
            ItemStack stack1;
            ItemStack stack0 = (ItemStack)sorting.get(i);
            if (!InventoryUtils.isItemStackEqual(stack0, stack1 = (ItemStack)sorting.get(i + 1)) || (use = Math.min((maxStack = Math.min(maxStackSize, stack0.func_77976_d())) - stack0.func_190916_E(), stack1.func_190916_E())) <= 0) continue;
            stack0.func_190917_f(use);
            stack1.func_190918_g(use);
            if (stack1.func_190926_b()) {
                sorting.remove(i + 1);
            }
            --i;
        }
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            inventory.func_70299_a(i, i < sorting.size() ? (ItemStack)sorting.get(i) : ItemStack.field_190927_a);
        }
    }
}

