/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.stack;

import com.creativemd.creativecore.common.utils.stack.InfoOre;
import com.creativemd.creativecore.common.utils.stack.InfoStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class InfoContainOre
extends InfoOre {
    public InfoContainOre(String name) {
        this(name, 1);
    }

    public InfoContainOre(String name, int stackSize) {
        super(name.toLowerCase(), stackSize);
    }

    public InfoContainOre() {
    }

    @Override
    public boolean isInstanceIgnoreSize(InfoStack info) {
        if (this.equalsIgnoreSize(info)) {
            return true;
        }
        if (info instanceof InfoOre) {
            return ((InfoOre)info).ore.toLowerCase().contains(this.ore);
        }
        return false;
    }

    @Override
    public InfoStack copy() {
        return new InfoContainOre(this.ore, this.stackSize);
    }

    @Override
    public ItemStack getItemStack(int stacksize) {
        String[] names = OreDictionary.getOreNames();
        for (int i = 0; i < names.length; ++i) {
            NonNullList stacks;
            if (!names[i].toLowerCase().contains(this.ore) || (stacks = OreDictionary.getOres((String)names[i])).size() <= 0) continue;
            ItemStack stack = ((ItemStack)stacks.get(0)).func_77946_l();
            if (stack.func_77952_i() == Short.MAX_VALUE) {
                stack.func_77964_b(0);
            }
            stack.func_190920_e(stacksize);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    protected boolean isStackInstanceIgnoreSize(ItemStack stack) {
        int[] ores = OreDictionary.getOreIDs((ItemStack)stack);
        for (int j = 0; j < ores.length; ++j) {
            if (!OreDictionary.getOreName((int)ores[j]).toLowerCase().contains(this.ore)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equalsIgnoreSize(Object object) {
        return object instanceof InfoContainOre && ((InfoContainOre)object).ore.equals(this.ore);
    }

    @Override
    public ArrayList<ItemStack> getAllPossibleItemStacks() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        List<ItemStack> stacks = InfoContainOre.getAllExistingItems();
        for (int i = 0; i < stacks.size(); ++i) {
            if (!this.isInstanceIgnoreSize(stacks.get(i))) continue;
            result.add(stacks.get(i));
        }
        return result;
    }
}

