/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.gui;

import com.creativemd.creativecore.gui.CoreControl;
import com.creativemd.creativecore.gui.GuiRenderHelper;
import com.creativemd.creativecore.gui.Rect;
import com.creativemd.creativecore.gui.client.style.Style;
import com.creativemd.creativecore.gui.container.GuiParent;
import com.creativemd.creativecore.gui.event.gui.GuiToolTipEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;

@SideOnly(value=Side.CLIENT)
public abstract class GuiControl
extends CoreControl {
    public static final ResourceLocation guiUtilsImage = new ResourceLocation("creativecore", "textures/gui/utils.png");
    public static Minecraft mc = Minecraft.func_71410_x();
    public static FontRenderer font = GuiControl.mc.field_71466_p;
    public static Style defaultStyle = Style.liteStyle;
    public int posX;
    public int posY;
    public int width;
    public int height;
    public float rotation;
    public boolean visible;
    protected Style style = null;
    protected int borderWidth = 1;
    protected int marginWidth = 2;
    protected ArrayList<String> customTooltip = null;
    private static final Rect screenRect = new Rect(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);

    public GuiControl(String name, int x, int y, int width, int height) {
        super(name);
        this.posX = x;
        this.posY = y;
        this.width = width + this.getContentOffset() * 2;
        this.height = height + this.getContentOffset() * 2;
        this.rotation = 0.0f;
        this.visible = true;
    }

    public GuiControl setDimension(int width, int height) {
        this.width = width + this.getContentOffset() * 2;
        this.height = height + this.getContentOffset() * 2;
        return this;
    }

    public GuiControl setRotation(float rotation) {
        this.rotation = rotation;
        return this;
    }

    public GuiControl setStyle(Style style) {
        this.style = style;
        return this;
    }

    public GuiControl setCustomTooltip(String ... lines) {
        this.customTooltip = new ArrayList<String>(Arrays.asList(lines));
        return this;
    }

    @Override
    public boolean isInteractable() {
        return super.isInteractable() && this.visible;
    }

    public Vec3d getMousePos() {
        return this.getParent().getMousePos();
    }

    public Vec3d rotateMouseVec(Vec3d mouse) {
        if (this.rotation == 0.0f) {
            return mouse;
        }
        Vec3d centerOffset = this.getCenterOffset();
        return GuiControl.getRotationAround(-this.rotation, mouse, new Vec3d((double)this.posX + centerOffset.field_72450_a, (double)this.posY + centerOffset.field_72448_b, 0.0));
    }

    public boolean isMouseOver() {
        Vec3d mouse = this.getParent().getMousePos();
        Vec3d pos = this.rotateMouseVec(mouse);
        return this.isInteractable() && this.visible && this.isMouseOver((int)pos.field_72450_a, (int)pos.field_72448_b);
    }

    public boolean isMouseOver(int posX, int posY) {
        return posX >= this.posX && posX < this.posX + this.width && posY >= this.posY && posY < this.posY + this.height;
    }

    public GuiParent getParent() {
        return (GuiParent)this.parent;
    }

    public Style getDefaultStyle() {
        return defaultStyle;
    }

    public boolean hasStyle() {
        if (this.parent != null && this.getParent().hasStyle()) {
            return true;
        }
        return this.style != null;
    }

    public Style getStyle() {
        if (this.style != null) {
            return this.style;
        }
        if (this.parent != null && this.hasStyle()) {
            return this.getParent().getStyle();
        }
        return this.getDefaultStyle();
    }

    public boolean hasBorder() {
        return true;
    }

    public boolean hasBackground() {
        return true;
    }

    public boolean hasMouseOverEffect() {
        return true;
    }

    public boolean canOverlap() {
        return false;
    }

    public GuiToolTipEvent getToolTipEvent() {
        ArrayList<String> toolTip = this.getTooltip();
        if (this.customTooltip != null) {
            if (toolTip == null) {
                toolTip = new ArrayList<String>(this.customTooltip);
            } else {
                toolTip.addAll(this.customTooltip);
            }
        }
        if (toolTip != null && toolTip.size() > 0) {
            return new GuiToolTipEvent(toolTip, this);
        }
        return null;
    }

    public ArrayList<String> getTooltip() {
        return null;
    }

    public Vec3d getCenterOffset() {
        return new Vec3d((double)(this.width / 2), (double)(this.height / 2), 0.0);
    }

    public int getContentOffset() {
        return this.borderWidth + this.marginWidth;
    }

    public boolean isVisibleInsideRect(int x, int y, int width, int height, float scale) {
        return (float)(this.posX + this.width) * scale >= (float)x * scale && (float)this.posX * scale <= (float)x * scale + (float)width && (float)(this.posY + this.height) * scale >= (float)y * scale && (float)this.posY * scale <= (float)y * scale + (float)height;
    }

    protected abstract void renderContent(GuiRenderHelper var1, Style var2, int var3, int var4);

    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height, Rect relativeMaximumRect) {
        this.renderContent(helper, style, width, height);
    }

    protected void renderBackground(GuiRenderHelper helper, Style style) {
        if (this.hasBorder()) {
            style.getBorder(this).renderStyle(helper, this.width, this.height);
        }
        GlStateManager.func_179109_b((float)this.borderWidth, (float)this.borderWidth, (float)0.0f);
        if (this.hasBackground()) {
            style.getBackground(this).renderStyle(helper, this.width - this.borderWidth * 2, this.height - this.borderWidth * 2);
        }
    }

    protected void renderForeground(GuiRenderHelper helper, Style style) {
        if (!this.enabled) {
            style.getDisableEffect(this).renderStyle(helper, this.width, this.height);
        }
    }

    protected Rect getRect() {
        return new Rect(0, 0, this.width - this.getContentOffset() * 2, this.height - this.getContentOffset() * 2);
    }

    protected void prepareContentStencil(GuiRenderHelper helper, Rect maximumRect) {
        int spaceUsed = this.borderWidth + this.marginWidth;
        Rect contentRect = this.getRect();
        GL11.glClear((int)1024);
        GL11.glStencilOp((int)7681, (int)7681, (int)7681);
        GL11.glStencilFunc((int)514, (int)1, (int)1);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        contentRect.mergeRects(maximumRect).renderRect(helper, new Color(0, 0, 0, 255));
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public void renderControl(GuiRenderHelper helper, float scale, Rect relativeMaximumRect) {
        if (!this.visible) {
            return;
        }
        Style style = this.getStyle();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.posX, (float)this.posY, (float)0.0f);
        if (this.rotation != 0.0f) {
            Vec3d centerOffset = this.getCenterOffset();
            GlStateManager.func_179137_b((double)centerOffset.field_72450_a, (double)centerOffset.field_72448_b, (double)0.0);
            GlStateManager.func_179114_b((float)this.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(-centerOffset.field_72450_a), (double)(-centerOffset.field_72448_b), (double)0.0);
        }
        if (scale != 0.0f) {
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        }
        this.renderBackground(helper, style);
        int spaceUsed = this.getContentOffset();
        GlStateManager.func_179109_b((float)this.marginWidth, (float)this.marginWidth, (float)0.0f);
        GL11.glEnable((int)2960);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glStencilFunc((int)514, (int)1, (int)1);
        this.renderContent(helper, style, this.width - spaceUsed * 2, this.height - spaceUsed * 2, relativeMaximumRect);
        GL11.glDisable((int)2960);
        GlStateManager.func_179109_b((float)(-spaceUsed), (float)(-spaceUsed), (float)0.0f);
        this.renderForeground(helper, style);
        GlStateManager.func_179121_F();
    }

    public void onLoseFocus() {
    }

    public boolean mouseScrolled(int x, int y, int scrolled) {
        return false;
    }

    public boolean mousePressed(int x, int y, int button) {
        return false;
    }

    public void mouseMove(int x, int y, int button) {
    }

    public void mouseReleased(int x, int y, int button) {
    }

    public void mouseDragged(int x, int y, int button, long time) {
    }

    public boolean onKeyPressed(char character, int key) {
        return false;
    }

    public static Rect getScreenRect() {
        return screenRect;
    }

    public static void playSound(SoundEvent event) {
        mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)event, (float)1.0f));
    }

    public static Vec3d getRotationAround(double angle, Vec3d pos, Vec3d center) {
        Vector2d result = new Vector2d(pos.field_72450_a, pos.field_72448_b);
        Vector2d newCenter = new Vector2d(center.field_72450_a, center.field_72448_b);
        result.sub((Tuple2d)newCenter);
        Vector2d temp = new Vector2d(result);
        result.x = Math.cos(Math.toRadians(angle)) * temp.x - Math.sin(Math.toRadians(angle)) * temp.y;
        result.y = Math.sin(Math.toRadians(angle)) * temp.x + Math.cos(Math.toRadians(angle)) * temp.y;
        result.add((Tuple2d)newCenter);
        return new Vec3d(result.x, result.y, 0.0);
    }
}

