/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import team.creative.creativecore.common.network.CanBeNull;
import team.creative.creativecore.common.network.CreativePacket;

public class CreativeFieldParserEntry {
    public final Field field;
    public boolean nullable;
    public final CreativeFieldParser parser;
    private static LinkedHashMap<Predicate<Class<?>>, Class<? extends CreativeFieldParserSpecial>> specialParsers = new LinkedHashMap();
    private static HashMap<Class<?>, CreativeFieldParser> parsers = new HashMap();

    public CreativeFieldParserEntry(Field field, CreativeFieldParser parser) {
        this.field = field;
        this.nullable = field.isAnnotationPresent(CanBeNull.class);
        this.parser = parser;
    }

    public void write(CreativePacket packet, PacketBuffer buffer) {
        try {
            Object content = this.field.get(packet);
            if (this.nullable) {
                buffer.writeBoolean(content != null);
            }
            if (content != null) {
                this.parser.write(content, buffer);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void read(CreativePacket packet, PacketBuffer buffer) {
        try {
            Object content = this.nullable && !buffer.readBoolean() ? null : this.parser.read(buffer);
            this.field.set(packet, content);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static <T> void registerParser(Class<T> classType, CreativeFieldParser parser) {
        parsers.put(classType, parser);
    }

    public static <T> void registerSpecialParser(Predicate<Class<?>> classType, Class<? extends CreativeFieldParserSpecial> parser) {
        specialParsers.put(classType, parser);
    }

    public static CreativeFieldParserEntry getParser(Field field) {
        CreativeFieldParser parser = CreativeFieldParserEntry.getParser(field.getType(), field.getGenericType());
        if (parser != null) {
            return new CreativeFieldParserEntry(field, parser);
        }
        return null;
    }

    public static CreativeFieldParser getParser(Class<?> classType, Type genericType) {
        try {
            CreativeFieldParser parser = parsers.get(classType);
            if (parser != null) {
                return parser;
            }
            for (Map.Entry<Predicate<Class<?>>, Class<CreativeFieldParserSpecial>> pair : specialParsers.entrySet()) {
                if (!pair.getKey().test(classType)) continue;
                return pair.getValue().getConstructor(Class.class, Type.class).newInstance(classType, genericType);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return null;
    }

    static {
        CreativeFieldParserEntry.registerParser(Boolean.TYPE, new BooleanFieldParser());
        CreativeFieldParserEntry.registerParser(Boolean.class, new BooleanFieldParser());
        CreativeFieldParserEntry.registerParser(Byte.TYPE, new ByteFieldParser());
        CreativeFieldParserEntry.registerParser(Byte.class, new ByteFieldParser());
        CreativeFieldParserEntry.registerParser(Short.TYPE, new ShortFieldParser());
        CreativeFieldParserEntry.registerParser(Short.class, new ShortFieldParser());
        CreativeFieldParserEntry.registerParser(Integer.TYPE, new IntFieldParser());
        CreativeFieldParserEntry.registerParser(Integer.class, new IntFieldParser());
        CreativeFieldParserEntry.registerParser(Long.TYPE, new LongFieldParser());
        CreativeFieldParserEntry.registerParser(Long.class, new LongFieldParser());
        CreativeFieldParserEntry.registerParser(Float.TYPE, new FloatFieldParser());
        CreativeFieldParserEntry.registerParser(Float.class, new FloatFieldParser());
        CreativeFieldParserEntry.registerParser(Double.TYPE, new DoubleFieldParser());
        CreativeFieldParserEntry.registerParser(Double.class, new DoubleFieldParser());
        CreativeFieldParserEntry.registerParser(BlockPos.class, new BlockPosFieldParser());
        CreativeFieldParserEntry.registerParser(String.class, new StringFieldParser());
        CreativeFieldParserEntry.registerParser(ITextComponent.class, new ITextComponentFieldParser());
        CreativeFieldParserEntry.registerParser(CompoundNBT.class, new NBTTagCompoundFieldParser());
        CreativeFieldParserEntry.registerParser(ItemStack.class, new ItemStackFieldParser());
        CreativeFieldParserEntry.registerParser(ResourceLocation.class, new ResourceLocationFieldParser());
        CreativeFieldParserEntry.registerParser(BlockState.class, new BlockStateFieldParser());
        CreativeFieldParserEntry.registerParser(Vec3d.class, new Vec3dFieldParser());
        CreativeFieldParserEntry.registerParser(UUID.class, new UUIDFieldParser());
        CreativeFieldParserEntry.registerSpecialParser(classType -> classType.isArray(), ArrayFieldParser.class);
        CreativeFieldParserEntry.registerSpecialParser(classType -> classType.equals(ArrayList.class) || classType.equals(List.class), ListFieldParser.class);
        CreativeFieldParserEntry.registerSpecialParser(classType -> classType.isEnum(), EnumFieldParser.class);
    }

    public static class UUIDFieldParser
    extends CreativeFieldParserType<UUID> {
        @Override
        protected void writeContent(UUID content, PacketBuffer buffer) {
            buffer.func_180714_a(content.toString());
        }

        @Override
        protected UUID readContent(PacketBuffer buffer) {
            return UUID.fromString(buffer.func_150789_c(Short.MAX_VALUE));
        }
    }

    public static class Vec3dFieldParser
    extends CreativeFieldParserType<Vec3d> {
        @Override
        protected void writeContent(Vec3d content, PacketBuffer buffer) {
            buffer.writeDouble(content.field_72450_a);
            buffer.writeDouble(content.field_72448_b);
            buffer.writeDouble(content.field_72449_c);
        }

        @Override
        protected Vec3d readContent(PacketBuffer buffer) {
            return new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    }

    public static class BlockStateFieldParser
    extends CreativeFieldParserType<BlockState> {
        @Override
        protected void writeContent(BlockState content, PacketBuffer buffer) {
            buffer.writeInt(Block.func_196246_j((BlockState)content));
        }

        @Override
        protected BlockState readContent(PacketBuffer buffer) {
            return Block.func_196257_b((int)buffer.readInt());
        }
    }

    public static class ResourceLocationFieldParser
    extends CreativeFieldParserType<ResourceLocation> {
        @Override
        protected void writeContent(ResourceLocation content, PacketBuffer buffer) {
            buffer.func_192572_a(content);
        }

        @Override
        protected ResourceLocation readContent(PacketBuffer buffer) {
            return buffer.func_192575_l();
        }
    }

    public static class ItemStackFieldParser
    extends CreativeFieldParserType<ItemStack> {
        @Override
        protected void writeContent(ItemStack content, PacketBuffer buffer) {
            buffer.func_150788_a(content);
        }

        @Override
        protected ItemStack readContent(PacketBuffer buffer) {
            return buffer.func_150791_c();
        }
    }

    public static class NBTTagCompoundFieldParser
    extends CreativeFieldParserType<CompoundNBT> {
        @Override
        protected void writeContent(CompoundNBT content, PacketBuffer buffer) {
            buffer.func_150786_a(content);
        }

        @Override
        protected CompoundNBT readContent(PacketBuffer buffer) {
            return buffer.func_150793_b();
        }
    }

    public static class ITextComponentFieldParser
    extends CreativeFieldParserType<ITextComponent> {
        @Override
        protected void writeContent(ITextComponent content, PacketBuffer buffer) {
            buffer.func_179256_a(content);
        }

        @Override
        protected ITextComponent readContent(PacketBuffer buffer) {
            return buffer.func_179258_d();
        }
    }

    public static class StringFieldParser
    extends CreativeFieldParserType<String> {
        @Override
        protected void writeContent(String content, PacketBuffer buffer) {
            buffer.func_180714_a(content);
        }

        @Override
        protected String readContent(PacketBuffer buffer) {
            return buffer.func_150789_c(Short.MAX_VALUE);
        }
    }

    public static class BlockPosFieldParser
    extends CreativeFieldParserType<BlockPos> {
        @Override
        protected void writeContent(BlockPos content, PacketBuffer buffer) {
            buffer.func_179255_a(content);
        }

        @Override
        protected BlockPos readContent(PacketBuffer buffer) {
            return buffer.func_179259_c();
        }
    }

    public static class DoubleFieldParser
    extends CreativeFieldParserType<Double> {
        @Override
        protected void writeContent(Double content, PacketBuffer buffer) {
            buffer.writeDouble(content.doubleValue());
        }

        @Override
        protected Double readContent(PacketBuffer buffer) {
            return buffer.readDouble();
        }
    }

    public static class FloatFieldParser
    extends CreativeFieldParserType<Float> {
        @Override
        protected void writeContent(Float content, PacketBuffer buffer) {
            buffer.writeFloat(content.floatValue());
        }

        @Override
        protected Float readContent(PacketBuffer buffer) {
            return Float.valueOf(buffer.readFloat());
        }
    }

    public static class LongFieldParser
    extends CreativeFieldParserType<Long> {
        @Override
        protected void writeContent(Long content, PacketBuffer buffer) {
            buffer.writeLong(content.longValue());
        }

        @Override
        protected Long readContent(PacketBuffer buffer) {
            return buffer.readLong();
        }
    }

    public static class IntFieldParser
    extends CreativeFieldParserType<Integer> {
        @Override
        protected void writeContent(Integer content, PacketBuffer buffer) {
            buffer.writeInt(content.intValue());
        }

        @Override
        protected Integer readContent(PacketBuffer buffer) {
            return buffer.readInt();
        }
    }

    public static class ShortFieldParser
    extends CreativeFieldParserType<Short> {
        @Override
        protected void writeContent(Short content, PacketBuffer buffer) {
            buffer.writeShort((int)content.shortValue());
        }

        @Override
        protected Short readContent(PacketBuffer buffer) {
            return buffer.readShort();
        }
    }

    public static class ByteFieldParser
    extends CreativeFieldParserType<Byte> {
        @Override
        protected void writeContent(Byte content, PacketBuffer buffer) {
            buffer.writeByte((int)content.byteValue());
        }

        @Override
        protected Byte readContent(PacketBuffer buffer) {
            return buffer.readByte();
        }
    }

    public static class BooleanFieldParser
    extends CreativeFieldParserType<Boolean> {
        @Override
        protected void writeContent(Boolean content, PacketBuffer buffer) {
            buffer.writeBoolean(content.booleanValue());
        }

        @Override
        protected Boolean readContent(PacketBuffer buffer) {
            return buffer.readBoolean();
        }
    }

    public static class EnumFieldParser
    extends CreativeFieldParserSpecial {
        public EnumFieldParser(Class<?> classType, Type genericType) throws Exception {
            super(classType, genericType);
        }

        @Override
        protected void write(Object content, PacketBuffer buffer) {
            buffer.func_179249_a((Enum)content);
        }

        @Override
        protected Object read(PacketBuffer buffer) {
            return buffer.func_179257_a(this.classType);
        }
    }

    public static class ListFieldParser
    extends CreativeFieldParserSpecial {
        public CreativeFieldParser subParser;

        public ListFieldParser(Class<?> classType, Type genericType) throws Exception {
            super(classType, genericType);
            if (genericType instanceof ParameterizedType) {
                Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
                if (types.length == 1) {
                    this.subParser = CreativeFieldParserEntry.getParser((Class)((ParameterizedType)genericType).getRawType(), types[0]);
                    if (this.subParser == null) {
                        throw new RuntimeException("Invalid class type " + classType.getComponentType().getName());
                    }
                }
            } else {
                throw new RuntimeException("Missing generic type");
            }
        }

        @Override
        protected void write(Object content, PacketBuffer buffer) {
            int length = Array.getLength(content);
            buffer.writeInt(length);
            for (int i = 0; i < length; ++i) {
                this.subParser.write(Array.get(content, i), buffer);
            }
        }

        @Override
        protected Object read(PacketBuffer buffer) {
            int length = buffer.readInt();
            Object object = Array.newInstance(this.classType.getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Array.set(object, i, this.subParser.read(buffer));
            }
            return object;
        }
    }

    public static class ArrayFieldParser
    extends CreativeFieldParserSpecial {
        public CreativeFieldParser subParser;

        public ArrayFieldParser(Class<?> classType, Type genericType) throws Exception {
            super(classType, genericType);
            this.subParser = CreativeFieldParserEntry.getParser(classType.getComponentType(), null);
            if (this.subParser == null) {
                throw new RuntimeException("Invalid class type " + classType.getComponentType().getName());
            }
        }

        @Override
        protected void write(Object content, PacketBuffer buffer) {
            int length = Array.getLength(content);
            buffer.writeInt(length);
            for (int i = 0; i < length; ++i) {
                this.subParser.write(Array.get(content, i), buffer);
            }
        }

        @Override
        protected Object read(PacketBuffer buffer) {
            int length = buffer.readInt();
            Object object = Array.newInstance(this.classType.getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Array.set(object, i, this.subParser.read(buffer));
            }
            return object;
        }
    }

    public static abstract class CreativeFieldParserSpecial
    extends CreativeFieldParser {
        public Class<?> classType;

        public CreativeFieldParserSpecial(Class<?> classType, Type genericType) throws Exception {
            this.classType = classType;
        }
    }

    public static abstract class CreativeFieldParserType<T>
    extends CreativeFieldParser {
        @Override
        protected void write(Object content, PacketBuffer buffer) {
            this.writeContent(content, buffer);
        }

        @Override
        protected Object read(PacketBuffer buffer) {
            return this.readContent(buffer);
        }

        protected abstract void writeContent(T var1, PacketBuffer var2);

        protected abstract T readContent(PacketBuffer var1);
    }

    public static abstract class CreativeFieldParser {
        protected abstract void write(Object var1, PacketBuffer var2);

        protected abstract Object read(PacketBuffer var1);
    }
}

