/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.common.network.CreativeFieldParserEntry;
import team.creative.creativecore.common.network.CreativePacket;

public class CreativeNetwork {
    private final Logger logger;
    private final String version;
    private int id = 0;
    public final SimpleChannel instance;

    private static PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public CreativeNetwork(String version, Logger logger, ResourceLocation location) {
        this.version = version;
        this.logger = logger;
        this.instance = NetworkRegistry.newSimpleChannel((ResourceLocation)location, () -> this.version, this.version::equals, this.version::equals);
        this.logger.debug("Created network " + location + "!");
    }

    public <T extends CreativePacket> void registerType(Class<T> classType) {
        CreativeBufferHandler handler = new CreativeBufferHandler(classType);
        this.instance.registerMessage(this.id, classType, (message, buffer) -> handler.write((Object)message, (PacketBuffer)buffer), buffer -> handler.read((PacketBuffer)buffer), (message, ctx) -> {
            message.execute((PlayerEntity)(((NetworkEvent.Context)ctx.get()).getSender() == null ? CreativeNetwork.getClientPlayer() : ((NetworkEvent.Context)ctx.get()).getSender()));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        ++this.id;
    }

    public void sendToServer(CreativePacket message) {
        this.instance.sendToServer((Object)message);
    }

    public void sendToClient(CreativePacket message, ServerPlayerEntity player) {
        this.instance.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }

    public void sendToClient(CreativePacket message, Chunk chunk) {
        this.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)message);
    }

    public void sendToClientTracking(CreativePacket message, Entity entity) {
        this.instance.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)message);
    }

    public void sendToClientAll(CreativePacket message) {
        this.instance.send(PacketDistributor.ALL.noArg(), (Object)message);
    }

    public static class CreativeBufferHandler<T extends CreativePacket> {
        public final Class<T> classType;
        public List<CreativeFieldParserEntry> parsers = new ArrayList<CreativeFieldParserEntry>();

        public CreativeBufferHandler(Class<T> classType) {
            this.classType = classType;
            for (Field field : this.classType.getFields()) {
                if (Modifier.isTransient(field.getModifiers()) && field.isAnnotationPresent(OnlyIn.class)) continue;
                CreativeFieldParserEntry parser = CreativeFieldParserEntry.getParser(field);
                if (parser != null) {
                    this.parsers.add(parser);
                    continue;
                }
                throw new RuntimeException("Could not find parser for " + classType.getName() + "." + field.getName() + "! type: " + field.getType().getName());
            }
        }

        public void write(T packet, PacketBuffer buffer) {
            for (CreativeFieldParserEntry parser : this.parsers) {
                parser.write((CreativePacket)packet, buffer);
            }
        }

        public T read(PacketBuffer buffer) {
            try {
                Constructor<T> constructor = this.classType.getConstructor(new Class[0]);
                CreativePacket message = (CreativePacket)constructor.newInstance(new Object[0]);
                for (CreativeFieldParserEntry parser : this.parsers) {
                    parser.read(message, buffer);
                }
                return (T)message;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

