/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.holder;

import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import team.creative.creativecore.common.config.ConfigTypeConveration;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.api.ICreativeConfig;
import team.creative.creativecore.common.config.holder.ConfigHolder;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;

public class ConfigHolderObject
extends ConfigHolder<ConfigKeyFieldObject> {
    public final Object object;

    private static List<Field> collectFields(Class clazz, List<Field> fields) {
        if (clazz.getSuperclass() != Object.class) {
            ConfigHolderObject.collectFields(clazz.getSuperclass(), fields);
        }
        Field[] declaredFields = clazz.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            if (!Modifier.isPublic(declaredFields[i].getModifiers())) continue;
            fields.add(declaredFields[i]);
        }
        return fields;
    }

    public ConfigHolderObject(ICreativeConfigHolder parent, ConfigSynchronization synchronization, String key, Object object) {
        super(parent, key, synchronization);
        this.object = object;
        List<Field> fields = ConfigHolderObject.collectFields(object.getClass(), new ArrayList<Field>());
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            if (!field.isAnnotationPresent(CreativeConfig.class)) continue;
            try {
                CreativeConfig config = field.getAnnotation(CreativeConfig.class);
                String name = config.name().isEmpty() ? field.getName() : config.name();
                ConfigSynchronization fieldSync = synchronization != ConfigSynchronization.UNIVERSAL ? synchronization : config.type();
                ConfigKeyFieldObject fieldKey = new ConfigKeyFieldObject(field, name, ConfigTypeConveration.parseObject(this, fieldSync, name, field.get(object)), fieldSync, config.requiresRestart());
                this.fields.add(name, fieldKey);
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void load(boolean loadDefault, JsonObject json, Dist side) {
        super.load(loadDefault, json, side);
        if (this.object instanceof ICreativeConfig) {
            ((ICreativeConfig)this.object).configured();
        }
    }

    @Override
    protected void reset(Dist side) {
        super.reset(side);
        if (this.object instanceof ICreativeConfig) {
            ((ICreativeConfig)this.object).configured();
        }
    }

    public class ConfigKeyFieldObject
    extends ConfigKey.ConfigKeyField {
        public ConfigKeyFieldObject(Field field, String name, Object defaultValue, ConfigSynchronization synchronization, boolean requiresRestart) {
            super(field, name, defaultValue, synchronization, requiresRestart);
        }

        @Override
        public Object getParent() {
            return this.getHolder().object;
        }

        public ConfigHolderObject getHolder() {
            return ConfigHolderObject.this;
        }
    }
}

