/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.vec;

import net.minecraft.util.math.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vector;

public class Vector3
extends Vector<Vector3> {
    public double x;
    public double y;
    public double z;

    public Vector3() {
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(Vector3 vec) {
        super(vec);
    }

    public Vector3(Vec3d vec) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Vec3d toVanilla() {
        return new Vec3d(this.x, this.y, this.z);
    }

    @Override
    public void set(Vector3 vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    @Override
    public double get(int dim) {
        switch (dim) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        return 0.0;
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void set(int dim, double value) {
        switch (dim) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
            }
        }
    }

    @Override
    public int dimensions() {
        return 3;
    }

    @Override
    public Vector3 copy() {
        return new Vector3(this.x, this.y, this.z);
    }

    @Override
    public void add(Vector3 vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
    }

    @Override
    public void sub(Vector3 vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
    }

    @Override
    public void scale(double scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Vector3) {
            return ((Vector3)obj).x == this.x && ((Vector3)obj).y == this.y && ((Vector3)obj).z == this.z;
        }
        return false;
    }

    @Override
    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @Override
    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    @Override
    public double angle(Vector3 vec) {
        double vDot = this.dot(vec) / (this.length() * vec.length());
        if (vDot < -1.0) {
            vDot = -1.0;
        }
        if (vDot > 1.0) {
            vDot = 1.0;
        }
        return Math.acos(vDot);
    }

    @Override
    public void cross(Vector3 vec1, Vector3 vec2) {
        this.x = vec1.y * vec2.z - vec1.z * vec2.y;
        this.y = vec2.x * vec1.z - vec2.z * vec1.x;
        this.z = vec1.x * vec2.y - vec1.y * vec2.x;
    }

    @Override
    public double dot(Vector3 vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }
}

