/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.packet;

import com.creativemd.creativecore.common.packet.CreativeMessageHandler;
import com.creativemd.creativecore.common.packet.CreativeSplittedMessageHandler;
import com.creativemd.creativecore.common.packet.PacketReciever;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SplittedPacketReceiver
implements IMessageHandler<CreativeSplittedMessageHandler, IMessage> {
    @SideOnly(value=Side.CLIENT)
    public void executeClient(IMessage message) {
        if (message instanceof CreativeSplittedMessageHandler) {
            CreativeSplittedMessageHandler cm = (CreativeSplittedMessageHandler)message;
            if (cm.isLast) {
                PacketReciever.PacketKey key = new PacketReciever.PacketKey(cm.packetID, cm.uuid);
                final PacketReciever.PacketValue value = PacketReciever.clientSplittedPackets.get(key);
                if (value == null) {
                    System.out.println("Something went wrong! Either a packet got lost or the receiving time has expired. " + key);
                    return;
                }
                try {
                    value.receivePacket(cm.buffer, 0, cm.length);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (cm.isLast) {
                    if (value != null && value.isComplete()) {
                        value.packet.readBytes(value.buf);
                        Minecraft.func_71410_x().func_152344_a(new Runnable(){

                            @Override
                            public void run() {
                                value.packet.executeClient((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                            }
                        });
                        PacketReciever.clientSplittedPackets.remove(key);
                    } else {
                        System.out.println("Something went wrong! Either a packet got lost or the receiving time has expired. " + key);
                    }
                }
            }
            PacketReciever.refreshQueue(false);
        }
    }

    public CreativeMessageHandler onMessage(CreativeSplittedMessageHandler message, final MessageContext ctx) {
        if (ctx.side.isClient()) {
            this.executeClient(message);
        } else if (message instanceof CreativeSplittedMessageHandler) {
            CreativeSplittedMessageHandler cm = message;
            PacketReciever.PacketKey key = new PacketReciever.PacketKey(cm.packetID, cm.uuid);
            final PacketReciever.PacketValue value = PacketReciever.splittedPackets.get(key);
            try {
                if (value == null) {
                    System.out.println("Something went wrong! Either a packet got lost or the receiving time has expired. " + key);
                    return null;
                }
                value.receivePacket(cm.buffer, 0, cm.length);
                if (cm.isLast) {
                    if (value != null && value.isComplete()) {
                        value.packet.readBytes(value.buf);
                        ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(new Runnable(){

                            @Override
                            public void run() {
                                value.packet.executeServer((EntityPlayer)ctx.getServerHandler().field_147369_b);
                            }
                        });
                        PacketReciever.splittedPackets.remove(key);
                    } else {
                        System.out.println("Something went wrong! Either a packet got lost or the receiving time has expired. " + key);
                    }
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            PacketReciever.refreshQueue(true);
        }
        return null;
    }
}

