/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HashMapList<K, V> {
    private HashMap<K, ArrayList<V>> keys = new HashMap();

    public ArrayList<V> getValues(K key) {
        return this.keys.get(key);
    }

    public K getKey(V search) {
        for (Map.Entry<K, ArrayList<V>> entry : this.keys.entrySet()) {
            if (!entry.getValue().contains(search)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Set<K> getKeys() {
        return this.keys.keySet();
    }

    public void add(K key, V value) {
        ArrayList<Object> list = this.getValues(key);
        if (list == null) {
            list = new ArrayList();
            list.add(value);
            this.keys.put(key, list);
        } else {
            list.add(value);
        }
    }

    public void add(K key, V[] values) {
        this.add(key, new ArrayList<V>(Arrays.asList(values)));
    }

    public void add(K key, ArrayList<V> values) {
        ArrayList<V> list = this.getValues(key);
        if (list == null) {
            this.keys.put(key, new ArrayList<V>(values));
        } else {
            list.addAll(values);
        }
    }

    public boolean removeKey(K key) {
        return this.keys.remove(key) != null;
    }

    public boolean removeValue(K key, V value) {
        ArrayList<V> values = this.getValues(key);
        if (values != null) {
            return values.remove(value);
        }
        return false;
    }

    public boolean removeValue(V value) {
        for (ArrayList<V> values : this.keys.values()) {
            if (!values.remove(value)) continue;
            return true;
        }
        return false;
    }

    public int sizeOfValues() {
        int size = 0;
        for (ArrayList<V> values : this.keys.values()) {
            size += values.size();
        }
        return size;
    }

    public int size() {
        return this.keys.size();
    }

    public void clear() {
        this.keys.clear();
    }

    public String toString() {
        return this.keys.toString();
    }
}

