/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.world;

import com.creativemd.creativecore.common.world.ChunkProviderFake;
import com.creativemd.creativecore.common.world.SaveHandlerFake;
import com.creativemd.creativecore.common.world.WorldFakeServer;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldFake
extends World {
    public final World parentWorld;
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRender;
    public Vector3d axis;
    public double rotX;
    public double rotY;
    public double rotZ;
    public double offsetX;
    public double offsetY;
    public double offsetZ;

    public static WorldFake createFakeWorld(World world) {
        if (world instanceof WorldServer) {
            return new WorldFakeServer((WorldServer)world);
        }
        return new WorldFake(world);
    }

    protected WorldFake(World world) {
        super((ISaveHandler)new SaveHandlerFake(world.func_72912_H()), world.func_72912_H(), world.field_73011_w, new Profiler(), world.field_72995_K);
        this.field_73020_y = this.func_72970_h();
        this.parentWorld = world;
    }

    protected IChunkProvider func_72970_h() {
        return new ChunkProviderFake(this, this.field_73019_z.func_75763_a(this.field_73011_w), this.field_73011_w.func_186060_c());
    }

    protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
        return ((ChunkProviderFake)this.func_72863_F()).chunkExists(x, z);
    }

    public Vector3d getRotatedVector(Vector3d vec) {
        Matrix3d matrixX = new Matrix3d();
        matrixX.rotX(Math.toRadians(this.rotX));
        Matrix3d matrixY = new Matrix3d();
        matrixY.rotY(Math.toRadians(this.rotY));
        Matrix3d matrixZ = new Matrix3d();
        matrixZ.rotZ(Math.toRadians(this.rotZ));
        vec.sub((Tuple3d)this.axis);
        matrixX.transform((Tuple3d)vec);
        matrixY.transform((Tuple3d)vec);
        matrixZ.transform((Tuple3d)vec);
        vec.add((Tuple3d)this.axis);
        vec.add((Tuple3d)new Vector3d(this.offsetX, this.offsetY, this.offsetZ));
        return vec;
    }

    public void func_175688_a(EnumParticleTypes particleType, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        this.spawnParticle(particleType.func_179348_c(), particleType.func_179344_e(), xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_175682_a(EnumParticleTypes particleType, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        this.spawnParticle(particleType.func_179348_c(), particleType.func_179344_e() || ignoreRange, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
    }

    private void spawnParticle(int particleID, boolean ignoreRange, double xCood, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            Vector3d pos = this.getRotatedVector(new Vector3d(xCood, yCoord, zCoord));
            ((IWorldEventListener)this.field_73021_x.get(i)).func_180442_a(particleID, ignoreRange, pos.x, pos.y, pos.z, xSpeed, ySpeed, zSpeed, parameters);
        }
    }
}

