/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.gui;

import com.creativemd.creativecore.gui.container.IControlParent;
import com.creativemd.creativecore.gui.event.ControlEvent;
import net.minecraft.entity.player.EntityPlayer;

public abstract class CoreControl {
    public IControlParent parent;
    public String name;
    public boolean enabled;
    private int id = -1;

    public void setID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public CoreControl(String name) {
        this.name = name;
        this.enabled = true;
    }

    public CoreControl setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void onOpened() {
    }

    public void onClosed() {
    }

    public void onTick() {
    }

    public boolean is(String ... name) {
        for (int i = 0; i < name.length; ++i) {
            if (!this.name.equalsIgnoreCase(name[i])) continue;
            return true;
        }
        return false;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public EntityPlayer getPlayer() {
        if (this.hasParent()) {
            return this.parent.getPlayer();
        }
        return null;
    }

    public boolean raiseEvent(ControlEvent event) {
        if (this.parent != null) {
            return ((CoreControl)((Object)this.parent)).raiseEvent(event);
        }
        return false;
    }

    public void addListener(Object listener) {
        if (this.parent != null) {
            ((CoreControl)((Object)this.parent)).addListener(listener);
        }
    }

    public void removeListener(Object listener) {
        if (this.parent != null) {
            ((CoreControl)((Object)this.parent)).removeListener(listener);
        }
    }

    public boolean isInteractable() {
        return this.enabled && this.hasParent() ? ((CoreControl)((Object)this.parent)).isInteractable() : true;
    }

    public void moveControlAbove(CoreControl controlInBack) {
        if (this.hasParent()) {
            this.parent.moveControlAbove(this, controlInBack);
        }
    }

    public void moveControlBehind(CoreControl controlInFront) {
        if (this.hasParent()) {
            this.parent.moveControlBehind(this, controlInFront);
        }
    }

    public void moveControlToBottom() {
        if (this.hasParent()) {
            this.parent.moveControlToBottom(this);
        }
    }

    public void moveControlToTop() {
        if (this.hasParent()) {
            this.parent.moveControlToTop(this);
        }
    }
}

