/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.gui.container;

import com.creativemd.creativecore.gui.ContainerControl;
import com.creativemd.creativecore.gui.CoreControl;
import com.creativemd.creativecore.gui.container.IControlParent;
import com.creativemd.creativecore.gui.controls.container.SlotControl;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ContainerParent
extends ContainerControl
implements IControlParent {
    public ArrayList<ContainerControl> controls = new ArrayList();

    public ContainerParent(String name) {
        super(name);
    }

    @Override
    public List getControls() {
        return this.controls;
    }

    @Override
    public CoreControl get(String name) {
        for (int i = 0; i < this.controls.size(); ++i) {
            if (!this.controls.get((int)i).name.equalsIgnoreCase(name)) continue;
            return this.controls.get(i);
        }
        return null;
    }

    @Override
    public boolean has(String name) {
        for (int i = 0; i < this.controls.size(); ++i) {
            if (!this.controls.get((int)i).name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onOpened() {
        for (int i = 0; i < this.controls.size(); ++i) {
            this.controls.get((int)i).parent = this;
            this.controls.get(i).onOpened();
        }
        this.refreshControls();
    }

    @Override
    public void onClosed() {
        for (int i = 0; i < this.controls.size(); ++i) {
            this.controls.get(i).onClosed();
        }
    }

    public void updateEqualContainers() {
        if (this.parent != null) {
            this.getParent().updateEqualContainers();
        }
    }

    @Override
    public void refreshControls() {
        for (int i = 0; i < this.controls.size(); ++i) {
            this.controls.get((int)i).parent = this;
            this.controls.get(i).setID(i);
        }
    }

    public void sendNBTUpdate(ContainerControl control, NBTTagCompound nbt) {
        if (this.parent != null) {
            this.getParent().sendNBTUpdate(control, nbt);
        }
    }

    @Override
    public void onTick() {
        for (int i = 0; i < this.controls.size(); ++i) {
            this.controls.get(i).onTick();
        }
    }

    public ArrayList<Slot> getSlots() {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < this.controls.size(); ++i) {
            if (!(this.controls.get(i) instanceof SlotControl)) continue;
            slots.add(((SlotControl)this.controls.get((int)i)).slot);
        }
        return slots;
    }

    public void addSlotToContainer(Slot slot) {
        this.controls.add(new SlotControl(slot));
    }

    public void addPlayerSlotsToContainer(EntityPlayer player) {
        this.addPlayerSlotsToContainer(player, -1);
    }

    public void addPlayerSlotsToContainer(EntityPlayer player, int indexUninteractable) {
        this.addPlayerSlotsToContainer(player, 8, 84, indexUninteractable);
    }

    public void addPlayerSlotsToContainer(EntityPlayer player, int x, int y) {
        this.addPlayerSlotsToContainer(player, x, y, -1);
    }

    public void addPlayerSlotsToContainer(EntityPlayer player, int x, int y, int indexUninteractable) {
        int l;
        for (l = 0; l < 3; ++l) {
            for (int i1 = 0; i1 < 9; ++i1) {
                int index = i1 + l * 9 + 9;
                if (index == indexUninteractable) {
                    this.addSlotToContainer(new Slot((IInventory)player.field_71071_by, index, i1 * 18 + x, l * 18 + y){

                        public boolean func_82869_a(EntityPlayer playerIn) {
                            return false;
                        }

                        public boolean func_75214_a(ItemStack stack) {
                            return false;
                        }
                    });
                    continue;
                }
                this.addSlotToContainer(new Slot((IInventory)player.field_71071_by, index, i1 * 18 + x, l * 18 + y));
            }
        }
        for (l = 0; l < 9; ++l) {
            if (l == indexUninteractable) {
                this.addSlotToContainer(new Slot((IInventory)player.field_71071_by, l, l * 18 + x, 58 + y){

                    public boolean func_82869_a(EntityPlayer playerIn) {
                        return false;
                    }

                    public boolean func_75214_a(ItemStack stack) {
                        return false;
                    }
                });
                continue;
            }
            this.addSlotToContainer(new Slot((IInventory)player.field_71071_by, l, l * 18 + x, 58 + y));
        }
    }
}

