/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.gui.controls.gui;

import com.creativemd.creativecore.gui.GuiControl;
import com.creativemd.creativecore.gui.GuiRenderHelper;
import com.creativemd.creativecore.gui.client.style.Style;

public class GuiProgressBar
extends GuiControl {
    public double pos;
    public double max;

    public GuiProgressBar(String name, int x, int y, int width, int height, double max, double pos) {
        super(name, x, y, width, height);
        this.max = max;
        this.pos = pos;
        this.marginWidth = 0;
    }

    public double getPercent() {
        return this.pos / this.max;
    }

    @Override
    public boolean hasMouseOverEffect() {
        return false;
    }

    @Override
    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        double percent = this.getPercent();
        int progressWidth = (int)((double)width * percent);
        if (progressWidth > 0) {
            style.getBorder(this).renderStyle(helper, progressWidth, height);
        }
        if (progressWidth > 1) {
            style.getFace(this).renderStyle(helper, progressWidth - 1, height);
        }
    }
}

