/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.gui.controls.gui.custom;

import com.creativemd.creativecore.gui.GuiRenderHelper;
import com.creativemd.creativecore.gui.client.style.Style;
import com.creativemd.creativecore.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.gui.controls.gui.custom.GuiItemStackSelector;
import com.creativemd.creativecore.gui.event.gui.GuiControlChangedEvent;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiInvSelector
extends GuiComboBox {
    public ArrayList<ItemStack> stacks = new ArrayList();
    public boolean onlyBlocks;
    public String search;

    public GuiInvSelector(String name, int x, int y, int width, EntityPlayer player, boolean onlyBlocks, String search) {
        super(name, x, y, width, new ArrayList<String>());
        this.search = search;
        this.onlyBlocks = onlyBlocks;
        this.updateItems(player);
    }

    public GuiInvSelector(String name, int x, int y, int width, EntityPlayer player, boolean onlyBlocks) {
        this(name, x, y, width, player, onlyBlocks, "");
    }

    public void updateItems(EntityPlayer player) {
        boolean shouldSearch = this.search.equals("");
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null) continue;
            newStacks.add(player.field_71071_by.field_70462_a[i].func_77946_l());
        }
        for (Item item : Item.field_150901_e) {
            if (item == null || item.func_77640_w() == null) continue;
            item.func_150895_a(item, (CreativeTabs)null, newStacks);
        }
        this.stacks.clear();
        this.lines.clear();
        for (int i = 0; i < newStacks.size(); ++i) {
            if (!GuiItemStackSelector.shouldShowItem(this.onlyBlocks, this.search, (ItemStack)newStacks.get(i))) continue;
            this.stacks.add((ItemStack)newStacks.get(i));
            this.lines.add(GuiItemStackSelector.getItemName((ItemStack)newStacks.get(i)));
        }
        if (this.lines.size() > 0) {
            this.index = 0;
            this.caption = (String)this.lines.get(0);
        } else {
            this.caption = "";
            this.index = -1;
        }
    }

    public void addAndSelectStack(ItemStack stack) {
        try {
            this.lines.add(stack.func_82833_r());
        }
        catch (Exception e) {
            this.lines.add(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString());
        }
        this.stacks.add(stack.func_77946_l());
        this.caption = (String)this.lines.get(this.lines.size() - 1);
        this.index = this.lines.size() - 1;
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    @Override
    protected int getAdditionalSize() {
        return 22;
    }

    @Override
    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        super.renderContent(helper, style, width, height);
        ItemStack stack = this.getStack();
        if (stack != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(width / 2 - (helper.getStringWidth(this.caption) + this.getAdditionalSize()) / 2), (float)(height / 2 - 8), (float)0.0f);
            helper.drawItemStack(stack, 0, 0, 16, 16);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void openBox() {
        this.extension = new GuiItemStackSelector(this.name + "extension", this.getPlayer(), this.posX, this.posY + this.height, this.width - this.getContentOffset() * 2, 80, this, this.onlyBlocks, this.search);
        this.getParent().controls.add(this.extension);
        this.extension.parent = this.parent;
        this.extension.moveControlToTop();
        this.extension.onOpened();
        this.parent.refreshControls();
        this.extension.rotation = this.rotation;
    }

    public ItemStack getStack() {
        if (this.index != -1 && this.index < this.stacks.size()) {
            return this.stacks.get(this.index);
        }
        return null;
    }
}

