/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.transformer;

import com.creativemd.creativecore.transformer.Transformer;
import java.util.ArrayList;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public abstract class CreativeTransformer
implements IClassTransformer {
    public final String modid;
    private final ArrayList<Transformer> transformers = new ArrayList();

    public CreativeTransformer(String modid) {
        this.modid = modid;
        this.initTransformers();
    }

    protected abstract void initTransformers();

    protected void addTransformer(Transformer transformer) {
        this.transformers.add(transformer);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (name.contains("com.creativemd")) {
            return basicClass;
        }
        return this.transform(transformedName, basicClass);
    }

    public byte[] transform(String name, byte[] basicClass) {
        int i = 0;
        while (i < this.transformers.size()) {
            if (this.transformers.get(i).is(name)) {
                ClassNode classNode = new ClassNode();
                ClassReader classReader = new ClassReader(basicClass);
                classReader.accept((ClassVisitor)classNode, 0);
                this.transformers.get(i).transform(classNode);
                ClassWriter writer = new ClassWriter(1);
                classNode.accept((ClassVisitor)writer);
                basicClass = writer.toByteArray();
                System.out.println("[" + this.modid + "] Patched " + this.transformers.get((int)i).className + " ...");
                this.transformers.get(i).done();
                ++i;
                continue;
            }
            ++i;
        }
        return basicClass;
    }
}

