/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.GBForgetools.GuiElements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import de.guntram.mcmod.GBForgetools.GuiElements.GuiSlider;
import de.guntram.mcmod.GBForgetools.GuiModOptions;
import de.guntram.mcmod.GBForgetools.Types.ConfigurationTrueColor;
import de.guntram.mcmod.GBForgetools.Types.SliderValueConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ColorPicker
extends Widget
implements SliderValueConsumer {
    private ColorDisplayAreaButton colorDisplay;
    private GuiSlider redSlider;
    private GuiSlider greenSlider;
    private GuiSlider blueSlider;
    private String option;
    private Widget element;
    private GuiModOptions optionScreen;
    private int currentColor;

    public ColorPicker(GuiModOptions optionScreen, int initialRGB, ITextComponent message) {
        super(0, 0, 250, 100, message);
        this.currentColor = initialRGB;
        this.optionScreen = optionScreen;
    }

    public void init() {
        StringTextComponent buttonITextComponent = new StringTextComponent("");
        this.field_230690_l_ = (this.optionScreen.field_230708_k_ - this.field_230688_j_) / 2;
        this.field_230691_m_ = (this.optionScreen.field_230709_l_ - this.field_230689_k_) / 2;
        this.colorDisplay = new ColorDisplayAreaButton(this, this.field_230690_l_, this.field_230691_m_, 20, 100, (ITextComponent)buttonITextComponent, this.currentColor);
        this.redSlider = new GuiSlider(this, this.field_230690_l_ + 50, this.field_230691_m_, 200, 20, this.currentColor >> 16 & 0xFF, 0, 255, "red");
        this.greenSlider = new GuiSlider(this, this.field_230690_l_ + 50, this.field_230691_m_ + 40, 200, 20, this.currentColor >> 16 & 0xFF, 0, 255, "green");
        this.blueSlider = new GuiSlider(this, this.field_230690_l_ + 50, this.field_230691_m_ + 80, 200, 20, this.currentColor >> 16 & 0xFF, 0, 255, "blue");
        this.field_230694_p_ = false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        return this.field_230694_p_ && (this.redSlider.func_231044_a_(mouseX, mouseY, button) || this.greenSlider.func_231044_a_(mouseX, mouseY, button) || this.blueSlider.func_231044_a_(mouseX, mouseY, button));
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            this.optionScreen.getFontRenderer().func_238421_b_(stack, "R", (float)(this.field_230690_l_ + 30), (float)(this.field_230691_m_ + 10), 0xFF0000);
            this.optionScreen.getFontRenderer().func_238421_b_(stack, "G", (float)(this.field_230690_l_ + 30), (float)(this.field_230691_m_ + 50), 65280);
            this.optionScreen.getFontRenderer().func_238421_b_(stack, "B", (float)(this.field_230690_l_ + 30), (float)(this.field_230691_m_ + 90), 255);
            this.colorDisplay.func_230430_a_(stack, mouseX, mouseY, partialTicks);
            this.redSlider.func_230430_a_(stack, mouseX, mouseY, this.field_230695_q_);
            this.greenSlider.func_230430_a_(stack, mouseX, mouseY, this.field_230695_q_);
            this.blueSlider.func_230430_a_(stack, mouseX, mouseY, this.field_230695_q_);
        }
    }

    public void setLink(String option, Widget element) {
        this.option = option;
        this.element = element;
    }

    public void setCurrentColor(ConfigurationTrueColor color) {
        this.currentColor = color.getInt();
        this.colorDisplay.setColor(this.currentColor);
        this.redSlider.reinitialize(color.red);
        this.greenSlider.reinitialize(color.green);
        this.blueSlider.reinitialize(color.blue);
    }

    public ConfigurationTrueColor getCurrentColor() {
        return new ConfigurationTrueColor(this.currentColor);
    }

    public void onDoneButton() {
        this.optionScreen.onConfigChanging(this.option, new ConfigurationTrueColor(this.currentColor));
        this.element.func_238482_a_(null);
        this.optionScreen.subscreenFinished();
    }

    @Override
    public void onConfigChanging(String color, Object value) {
        if (color.equals("red")) {
            this.currentColor = this.currentColor & 0xFFFF | (Integer)value << 16;
        } else if (color.equals("green")) {
            this.currentColor = this.currentColor & 0xFF00FF | (Integer)value << 8;
        } else if (color.equals("blue")) {
            this.currentColor = this.currentColor & 0xFFFF00 | (Integer)value;
        }
        this.colorDisplay.setColor(this.currentColor);
        this.optionScreen.onConfigChanging(this.option, new ConfigurationTrueColor(this.currentColor));
    }

    @Override
    public boolean wasMouseReleased() {
        return this.optionScreen.wasMouseReleased();
    }

    @Override
    public void setMouseReleased(boolean value) {
        this.optionScreen.setMouseReleased(value);
    }

    private class ColorDisplayAreaButton
    extends Widget {
        private final ColorPicker parent;
        private int rgb;

        public ColorDisplayAreaButton(ColorPicker parent, int x, int y, int width, int height, ITextComponent message, int rgb) {
            super(x, y, width, height, message);
            this.rgb = rgb;
            this.parent = parent;
        }

        public void setColor(int rgb) {
            this.rgb = rgb;
        }

        protected void func_230441_a_(MatrixStack stack, Minecraft mc, int mouseX, int mouseY) {
            if (this.field_230694_p_) {
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferBuilder = tessellator.func_178180_c();
                float red = (float)(this.rgb >> 16) / 255.0f;
                float green = (float)(this.rgb >> 8 & 0xFF) / 255.0f;
                float blue = (float)(this.rgb >> 0 & 0xFF) / 255.0f;
                GlStateManager.func_227621_I_();
                bufferBuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                Matrix4f model = stack.func_227866_c_().func_227870_a_();
                int x1 = this.field_230690_l_;
                int x2 = this.field_230690_l_ + this.field_230688_j_;
                int y1 = this.field_230691_m_;
                int y2 = this.field_230691_m_ + this.field_230689_k_;
                bufferBuilder.func_227888_a_(model, (float)x1, (float)y1, 0.0f).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
                bufferBuilder.func_227888_a_(model, (float)x1, (float)y2, 0.0f).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
                bufferBuilder.func_227888_a_(model, (float)x2, (float)y2, 0.0f).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
                bufferBuilder.func_227888_a_(model, (float)x2, (float)y1, 0.0f).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_227619_H_();
            }
        }
    }
}

