/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.client.gui;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.guntram.mcmod.durabilityviewer.DurabilityViewer;
import de.guntram.mcmod.durabilityviewer.handler.ConfigurationHandler;
import de.guntram.mcmod.durabilityviewer.itemindicator.InventorySlotsIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemCountIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemDamageIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemIndicator;
import de.guntram.mcmod.durabilityviewer.sound.ItemBreakingWarner;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.glfw.GLFW;

public class GuiItemDurability
extends Gui {
    private final Minecraft minecraft = Minecraft.m_91087_();
    private static boolean visible;
    private final Font fontRenderer;
    private final ItemRenderer itemRenderer;
    private long lastWarningTime;
    private ItemStack lastWarningItem;
    private static final int iconWidth = 16;
    private static final int iconHeight = 16;
    private static final int spacing = 2;
    private ItemBreakingWarner mainHandWarner;
    private ItemBreakingWarner offHandWarner;
    private ItemBreakingWarner helmetWarner;
    private ItemBreakingWarner chestWarner;
    private ItemBreakingWarner pantsWarner;
    private ItemBreakingWarner bootsWarner;

    public static void toggleVisibility() {
        visible = !visible;
    }

    public GuiItemDurability() {
        super(Minecraft.m_91087_());
        this.fontRenderer = this.minecraft.f_91062_;
        this.itemRenderer = this.minecraft.m_91291_();
        visible = true;
        this.mainHandWarner = new ItemBreakingWarner();
        this.offHandWarner = new ItemBreakingWarner();
        this.helmetWarner = new ItemBreakingWarner();
        this.chestWarner = new ItemBreakingWarner();
        this.pantsWarner = new ItemBreakingWarner();
        this.bootsWarner = new ItemBreakingWarner();
    }

    private int getInventoryArrowCount() {
        int arrows = 0;
        for (ItemStack stack : this.minecraft.f_91074_.m_150109_().f_35974_) {
            if (!this.isArrow(stack)) continue;
            arrows += stack.m_41613_();
        }
        return arrows;
    }

    private ItemStack getFirstArrowStack() {
        if (this.isArrow(this.minecraft.f_91074_.m_21120_(InteractionHand.OFF_HAND))) {
            return this.minecraft.f_91074_.m_21120_(InteractionHand.OFF_HAND);
        }
        if (this.isArrow(this.minecraft.f_91074_.m_21120_(InteractionHand.MAIN_HAND))) {
            return this.minecraft.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        }
        int size = this.minecraft.f_91074_.m_150109_().m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack itemstack = this.minecraft.f_91074_.m_150109_().m_8020_(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    private boolean isArrow(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() instanceof ArrowItem;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRender(RenderGameOverlayEvent.PostLayer event) {
        int ypos;
        int xposTools;
        int xposArmor;
        InventorySlotsIndicator invSlots;
        String newTitle = DurabilityViewer.getAndResetChangedWindowTitle();
        if (newTitle != null) {
            GLFW.glfwSetWindowTitle((long)this.minecraft.m_91268_().m_85439_(), (CharSequence)newTitle);
        }
        if (!visible || event.isCanceled() || event.getOverlay() != ForgeIngameGui.HOTBAR_ELEMENT) {
            return;
        }
        LocalPlayer effectivePlayer = this.minecraft.f_91074_;
        ItemStack needToWarn = null;
        ItemDamageIndicator mainHand = new ItemDamageIndicator(effectivePlayer.m_6844_(EquipmentSlot.MAINHAND));
        ItemDamageIndicator offHand = new ItemDamageIndicator(effectivePlayer.m_6844_(EquipmentSlot.OFFHAND));
        ItemDamageIndicator boots = new ItemDamageIndicator(effectivePlayer.m_6844_(EquipmentSlot.FEET));
        ItemDamageIndicator leggings = new ItemDamageIndicator(effectivePlayer.m_6844_(EquipmentSlot.LEGS));
        ItemDamageIndicator chestplate = new ItemDamageIndicator(effectivePlayer.m_6844_(EquipmentSlot.CHEST));
        ItemDamageIndicator helmet = new ItemDamageIndicator(effectivePlayer.m_6844_(EquipmentSlot.HEAD));
        ItemCountIndicator arrows = null;
        InventorySlotsIndicator inventorySlotsIndicator = invSlots = ConfigurationHandler.getShowChestIcon() ? new InventorySlotsIndicator(this.minecraft.f_91074_.m_150109_()) : null;
        if (needToWarn == null && this.mainHandWarner.checkBreaks(effectivePlayer.m_6844_(EquipmentSlot.MAINHAND))) {
            needToWarn = effectivePlayer.m_6844_(EquipmentSlot.MAINHAND);
        }
        if (needToWarn == null && this.offHandWarner.checkBreaks(effectivePlayer.m_6844_(EquipmentSlot.OFFHAND))) {
            needToWarn = effectivePlayer.m_6844_(EquipmentSlot.OFFHAND);
        }
        if (needToWarn == null && this.bootsWarner.checkBreaks(effectivePlayer.m_6844_(EquipmentSlot.FEET))) {
            needToWarn = effectivePlayer.m_6844_(EquipmentSlot.FEET);
        }
        if (needToWarn == null && this.pantsWarner.checkBreaks(effectivePlayer.m_6844_(EquipmentSlot.LEGS))) {
            needToWarn = effectivePlayer.m_6844_(EquipmentSlot.LEGS);
        }
        if (needToWarn == null && this.chestWarner.checkBreaks(effectivePlayer.m_6844_(EquipmentSlot.CHEST))) {
            needToWarn = effectivePlayer.m_6844_(EquipmentSlot.CHEST);
        }
        if (needToWarn == null && this.helmetWarner.checkBreaks(effectivePlayer.m_6844_(EquipmentSlot.HEAD))) {
            needToWarn = effectivePlayer.m_6844_(EquipmentSlot.HEAD);
        }
        if (needToWarn != null) {
            if ((ConfigurationHandler.getWarnMode() & 1) == 1) {
                ItemBreakingWarner.playWarningSound();
            }
            this.lastWarningTime = System.currentTimeMillis();
            this.lastWarningItem = needToWarn;
        }
        if (mainHand.getItemStack().m_41720_() instanceof BowItem || offHand.getItemStack().m_41720_() instanceof BowItem) {
            arrows = new ItemCountIndicator(this.getFirstArrowStack(), this.getInventoryArrowCount());
        }
        Window mainWindow = Minecraft.m_91087_().m_91268_();
        PoseStack stack = event.getMatrixStack();
        RenderSize armorSize = this.renderItems(stack, 0, 0, false, RenderPos.left, 0, boots, leggings, chestplate, helmet);
        RenderSize toolsSize = this.renderItems(stack, 0, 0, false, RenderPos.right, 0, invSlots, mainHand, offHand, arrows);
        int totalHeight = toolsSize.height > armorSize.height ? toolsSize.height : armorSize.height;
        int totalWidth = toolsSize.width > armorSize.width ? toolsSize.width : armorSize.width;
        switch (ConfigurationHandler.getCorner()) {
            case TOP_LEFT: {
                xposArmor = 5;
                xposTools = 5 + armorSize.width;
                ypos = 5;
                break;
            }
            case TOP_RIGHT: {
                xposArmor = mainWindow.m_85445_() - 5 - armorSize.width;
                xposTools = mainWindow.m_85445_() - 5 - armorSize.width - toolsSize.width;
                ypos = 60;
                break;
            }
            case BOTTOM_LEFT: {
                xposArmor = 5;
                xposTools = 5 + armorSize.width;
                ypos = mainWindow.m_85446_() - 5 - totalHeight;
                break;
            }
            case BOTTOM_RIGHT: {
                xposArmor = mainWindow.m_85445_() - 5 - armorSize.width;
                xposTools = mainWindow.m_85445_() - 5 - armorSize.width - toolsSize.width;
                ypos = mainWindow.m_85446_() - 5 - totalHeight;
                break;
            }
            default: {
                return;
            }
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (ConfigurationHandler.getArmorAroundHotbar()) {
            int leftOffset = -120;
            int rightOffset = 100;
            if (!effectivePlayer.m_6844_(EquipmentSlot.OFFHAND).m_41619_()) {
                if (this.minecraft.f_91066_.f_92127_ == HumanoidArm.RIGHT) {
                    leftOffset -= 20;
                } else {
                    rightOffset += 20;
                }
            }
            int helmetTextWidth = this.fontRenderer.m_92895_(helmet.getDisplayValue());
            int chestTextWidth = this.fontRenderer.m_92895_(chestplate.getDisplayValue());
            this.renderItems(stack, mainWindow.m_85445_() / 2 + leftOffset - helmetTextWidth, mainWindow.m_85446_() - 32 - 2, true, RenderPos.left, helmetTextWidth + 16 + 2, helmet);
            this.renderItems(stack, mainWindow.m_85445_() / 2 + leftOffset - chestTextWidth, mainWindow.m_85446_() - 16 - 2, true, RenderPos.left, chestTextWidth + 16 + 2, chestplate);
            this.renderItems(stack, mainWindow.m_85445_() / 2 + rightOffset, mainWindow.m_85446_() - 32 - 2, true, RenderPos.right, armorSize.width, leggings);
            this.renderItems(stack, mainWindow.m_85445_() / 2 + rightOffset, mainWindow.m_85446_() - 16 - 2, true, RenderPos.right, armorSize.width, boots);
            xposTools = ConfigurationHandler.getCorner().isRight() ? (xposTools += armorSize.width) : (xposTools -= armorSize.width);
        } else {
            this.renderItems(stack, xposArmor, ypos, true, ConfigurationHandler.getCorner().isLeft() ? RenderPos.left : RenderPos.right, armorSize.width, helmet, chestplate, leggings, boots);
        }
        this.renderItems(stack, xposTools, ypos, true, ConfigurationHandler.getCorner().isRight() ? RenderPos.right : RenderPos.left, toolsSize.width, invSlots, mainHand, offHand, arrows);
        long timeSinceLastWarning = System.currentTimeMillis() - this.lastWarningTime;
        if (timeSinceLastWarning < 1000L && (ConfigurationHandler.getWarnMode() & 2) == 2) {
            this.renderItemBreakingOverlay(stack, this.lastWarningItem, timeSinceLastWarning);
        }
    }

    private void renderItemBreakingOverlay(PoseStack matrices, ItemStack itemStack, long timeDelta) {
        Window mainWindow = Minecraft.m_91087_().m_91268_();
        float alpha = 1.0f - (float)timeDelta / 1000.0f;
        float xWarn = mainWindow.m_85445_() / 2;
        float yWarn = mainWindow.m_85446_() / 2;
        float scale = 5.0f;
        GuiComponent.m_93172_((PoseStack)matrices, (int)0, (int)0, (int)mainWindow.m_85445_(), (int)mainWindow.m_85446_(), (int)(0xFF0000 + ((int)(alpha * 128.0f) << 24)));
        PoseStack stack = RenderSystem.m_157191_();
        stack.m_85836_();
        stack.m_85841_(scale, scale, scale);
        RenderSystem.m_157182_();
        this.itemRenderer.m_115123_(itemStack, (int)(xWarn / scale - 8.0f), (int)(yWarn / scale - 8.0f));
        stack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void afterRenderStatusEffects(RenderGameOverlayEvent.PostLayer event) {
        if (!visible || event.isCanceled() || event.getOverlay() != ForgeIngameGui.POTION_ICONS_ELEMENT) {
            return;
        }
        if (ConfigurationHandler.showEffectDuration()) {
            Window mainWindow = this.minecraft.m_91268_();
            Collection collection = this.minecraft.f_91074_.m_21220_();
            int posGood = 0;
            int posBad = 0;
            for (MobEffectInstance potioneffect : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
                int ypos;
                if (!potioneffect.m_19572_()) continue;
                MobEffect potion = potioneffect.m_19544_();
                int xpos = mainWindow.m_85445_();
                if (potion.m_19486_()) {
                    xpos -= (posGood += 25);
                    ypos = 15;
                } else {
                    xpos -= (posBad += 25);
                    ypos = 41;
                }
                int duration = potioneffect.m_19557_();
                String show = duration > 1200 ? duration / 1200 + "m" : duration / 20 + "s";
                this.fontRenderer.m_92883_(event.getMatrixStack(), show, (float)(xpos + 2), (float)ypos, ItemIndicator.color_yellow);
            }
        }
    }

    private RenderSize renderItems(PoseStack stack, int xpos, int ypos, boolean reallyDraw, RenderPos numberPos, int maxWidth, ItemIndicator ... items) {
        RenderSize result = new RenderSize(0, 0);
        for (ItemIndicator item : items) {
            if (item == null || item.isEmpty() || !item.isItemStackDamageable()) continue;
            String displayString = item.getDisplayValue();
            int width = this.fontRenderer.m_92895_(displayString);
            if (width > result.width) {
                result.width = width;
            }
            if (reallyDraw) {
                int color = item.getDisplayColor();
                this.itemRenderer.m_115203_(item.getItemStack(), numberPos == RenderPos.left ? xpos + maxWidth - 16 - 2 : xpos, ypos + result.height);
                float f = numberPos != RenderPos.right ? (float)xpos : (float)(xpos + 16 + 2);
                int n = ypos + result.height;
                Objects.requireNonNull(this.fontRenderer);
                this.fontRenderer.m_92883_(stack, displayString, f, (float)(n + 9 / 2 + (numberPos == RenderPos.over ? 10 : 0)), color);
            }
            result.height += 16;
        }
        if (result.width != 0) {
            result.width += 20;
        }
        return result;
    }

    private static enum RenderPos {
        left,
        over,
        right;

    }

    private class RenderSize {
        int width;
        int height;

        RenderSize(int w, int h) {
            this.width = w;
            this.height = h;
        }
    }
}

