/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.itemindicator;

import de.guntram.mcmod.durabilityviewer.handler.ConfigurationHandler;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemIndicator;
import net.minecraft.world.item.ItemStack;

public class ItemDamageIndicator
implements ItemIndicator {
    final ItemStack stack;

    public ItemDamageIndicator(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public String getDisplayValue() {
        if (!this.stack.m_41763_()) {
            return "";
        }
        int max = this.stack.m_41776_();
        int cur = this.stack.m_41776_() - this.stack.m_41773_();
        int shown = cur > max * ConfigurationHandler.showDamageOverPercent() / 100 ? -this.stack.m_41773_() : cur;
        if (ConfigurationHandler.getShowPercentValues()) {
            return String.format("%.1f%%", (double)shown * 100.0 / (double)this.stack.m_41776_());
        }
        return String.valueOf(shown);
    }

    @Override
    public int getDisplayColor() {
        int max = this.stack.m_41776_();
        int cur = this.stack.m_41773_();
        if (cur < max / 5) {
            return color_green;
        }
        if (cur > max * 9 / 10 && cur > max - 100) {
            return color_red;
        }
        if (cur > max * 4 / 5 && cur > max - 200) {
            return color_yellow;
        }
        return color_white;
    }

    @Override
    public boolean isEmpty() {
        return this.stack.m_41619_();
    }

    @Override
    public boolean isItemStackDamageable() {
        return this.stack.m_41763_();
    }

    @Override
    public ItemStack getItemStack() {
        return this.stack;
    }
}

