/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.client.gui;

import com.google.common.collect.Ordering;
import de.guntram.mcmod.durabilityviewer.handler.ConfigurationHandler;
import de.guntram.mcmod.durabilityviewer.itemindicator.InventorySlotsIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemCountIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemDamageIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemIndicator;
import de.guntram.mcmod.durabilityviewer.sound.ItemBreakingWarner;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Collection;
import net.minecraft.class_1041;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1744;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4493;
import net.minecraft.class_746;
import net.minecraft.class_918;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiItemDurability {
    private static final Logger LOGGER = LogManager.getLogger();
    private final class_310 minecraft = class_310.method_1551();
    private static boolean visible;
    private final class_327 fontRenderer;
    private final class_918 itemRenderer;
    private static final int iconWidth = 16;
    private static final int iconHeight = 16;
    private static final int spacing = 2;
    private static boolean haveTrinketsApi;
    private ItemBreakingWarner mainHandWarner;
    private ItemBreakingWarner offHandWarner;
    private ItemBreakingWarner helmetWarner;
    private ItemBreakingWarner chestWarner;
    private ItemBreakingWarner pantsWarner;
    private ItemBreakingWarner bootsWarner;
    private ItemBreakingWarner[] trinketWarners;

    public static void toggleVisibility() {
        visible = !visible;
    }

    public GuiItemDurability() {
        this.fontRenderer = this.minecraft.field_1772;
        this.itemRenderer = this.minecraft.method_1480();
        visible = true;
        this.mainHandWarner = new ItemBreakingWarner();
        this.offHandWarner = new ItemBreakingWarner();
        this.helmetWarner = new ItemBreakingWarner();
        this.chestWarner = new ItemBreakingWarner();
        this.pantsWarner = new ItemBreakingWarner();
        this.bootsWarner = new ItemBreakingWarner();
        try {
            Class.forName("dev.emi.trinkets.api.TrinketsApi");
            LOGGER.info("Using trinkets in DurabilityViewer");
            haveTrinketsApi = true;
            this.trinketWarners = new ItemBreakingWarner[TrinketsApi.getTrinketsInventory((class_1657)this.minecraft.field_1724).method_5439()];
            for (int i = 0; i < this.trinketWarners.length; ++i) {
                this.trinketWarners[i] = new ItemBreakingWarner();
            }
        }
        catch (ClassNotFoundException ex) {
            LOGGER.info("DurabilityViewer did not find Trinkets API");
            this.trinketWarners = new ItemBreakingWarner[0];
        }
    }

    private int getInventoryArrowCount() {
        int arrows = 0;
        for (class_1799 stack : this.minecraft.field_1724.field_7514.field_7547) {
            if (!this.isArrow(stack)) continue;
            arrows += stack.method_7947();
        }
        return arrows;
    }

    private class_1799 getFirstArrowStack() {
        if (this.isArrow(this.minecraft.field_1724.method_6079())) {
            return this.minecraft.field_1724.method_6079();
        }
        if (this.isArrow(this.minecraft.field_1724.method_6047())) {
            return this.minecraft.field_1724.method_6047();
        }
        int size = this.minecraft.field_1724.field_7514.method_5439();
        for (int i = 0; i < size; ++i) {
            class_1799 itemstack = this.minecraft.field_1724.field_7514.method_5438(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    private boolean isArrow(class_1799 stack) {
        return !stack.method_7960() && stack.method_7909() instanceof class_1744;
    }

    public void onRenderGameOverlayPost(float partialTicks) {
        int ypos;
        int xposTrinkets;
        int xposTools;
        int xposArmor;
        int totalHeight;
        class_1263 inventory;
        if (!visible || this.minecraft.field_1724.field_7503.field_7477 || this.minecraft.field_1690.field_1866) {
            return;
        }
        class_746 player = this.minecraft.field_1724;
        boolean needToWarn = false;
        ItemDamageIndicator mainHand = new ItemDamageIndicator(player.method_6118(class_1304.field_6173));
        ItemDamageIndicator offHand = new ItemDamageIndicator(player.method_6118(class_1304.field_6171));
        ItemDamageIndicator boots = new ItemDamageIndicator(player.method_6118(class_1304.field_6166));
        ItemDamageIndicator leggings = new ItemDamageIndicator(player.method_6118(class_1304.field_6172));
        ItemDamageIndicator chestplate = new ItemDamageIndicator(player.method_6118(class_1304.field_6174));
        ItemDamageIndicator helmet = new ItemDamageIndicator(player.method_6118(class_1304.field_6169));
        ItemCountIndicator arrows = null;
        InventorySlotsIndicator invSlots = ConfigurationHandler.getShowChestIcon() ? new InventorySlotsIndicator(this.minecraft.field_1724.field_7514) : null;
        ItemIndicator[] trinkets = null;
        if (haveTrinketsApi) {
            inventory = TrinketsApi.getTrinketsInventory((class_1657)player);
            int itemCount = inventory.method_5439();
            trinkets = new ItemIndicator[itemCount];
            for (int i = 0; i < itemCount; ++i) {
                trinkets[i] = new ItemDamageIndicator(inventory.method_5438(i), ConfigurationHandler.getShowAllTrinkets());
                LOGGER.debug("trinket position " + i + " has item " + inventory.method_5438(i).method_7909().toString());
            }
        } else {
            trinkets = new ItemIndicator[]{};
        }
        needToWarn |= this.mainHandWarner.checkBreaks(player.method_6118(class_1304.field_6173));
        needToWarn |= this.offHandWarner.checkBreaks(player.method_6118(class_1304.field_6171));
        needToWarn |= this.bootsWarner.checkBreaks(player.method_6118(class_1304.field_6166));
        needToWarn |= this.pantsWarner.checkBreaks(player.method_6118(class_1304.field_6172));
        needToWarn |= this.chestWarner.checkBreaks(player.method_6118(class_1304.field_6174));
        needToWarn |= this.helmetWarner.checkBreaks(player.method_6118(class_1304.field_6169));
        if (haveTrinketsApi) {
            inventory = TrinketsApi.getTrinketsInventory((class_1657)player);
            LOGGER.debug("know about " + trinkets.length + " trinkets, invSize is " + inventory.method_5439() + ", have " + this.trinketWarners.length + " warners");
            for (int i = 0; i < trinkets.length; ++i) {
                needToWarn |= this.trinketWarners[i].checkBreaks(inventory.method_5438(i));
            }
        }
        if (needToWarn) {
            ItemBreakingWarner.playWarningSound();
        }
        if (mainHand.getItemStack().method_7909() instanceof class_1811 || offHand.getItemStack().method_7909() instanceof class_1811) {
            arrows = new ItemCountIndicator(this.getFirstArrowStack(), this.getInventoryArrowCount());
        }
        class_1041 mainWindow = class_310.method_1551().method_22683();
        RenderSize armorSize = ConfigurationHandler.getArmorAroundHotbar() ? new RenderSize(0, 0) : this.renderItems(0, 0, false, RenderPos.left, 0, boots, leggings, chestplate, helmet);
        RenderSize toolsSize = this.renderItems(0, 0, false, RenderPos.right, 0, invSlots, mainHand, offHand, arrows);
        RenderSize trinketsSize = this.renderItems(0, 0, false, RenderPos.left, 0, trinkets);
        int n = totalHeight = toolsSize.height > armorSize.height ? toolsSize.height : armorSize.height;
        if (trinketsSize.height > totalHeight) {
            totalHeight = trinketsSize.height;
        }
        switch (ConfigurationHandler.getCorner()) {
            case TOP_LEFT: {
                xposArmor = 5;
                xposTools = 5 + armorSize.width;
                xposTrinkets = 5 + armorSize.width + trinketsSize.width;
                ypos = 5;
                break;
            }
            case TOP_RIGHT: {
                xposArmor = mainWindow.method_4486() - 5 - armorSize.width;
                xposTools = xposArmor - toolsSize.width;
                xposTrinkets = xposTools - trinketsSize.width;
                ypos = 60;
                break;
            }
            case BOTTOM_LEFT: {
                xposArmor = 5;
                xposTools = 5 + armorSize.width;
                xposTrinkets = 5 + armorSize.width + trinketsSize.width;
                ypos = mainWindow.method_4502() - 5 - totalHeight;
                break;
            }
            case BOTTOM_RIGHT: {
                xposArmor = mainWindow.method_4486() - 5 - armorSize.width;
                xposTools = mainWindow.method_4486() - 5 - armorSize.width - toolsSize.width;
                xposTrinkets = xposTools - trinketsSize.width;
                ypos = mainWindow.method_4502() - 5 - totalHeight;
                break;
            }
            default: {
                return;
            }
        }
        class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (ConfigurationHandler.getArmorAroundHotbar()) {
            int leftOffset = -130;
            int rightOffset = 100;
            if (!player.method_6118(class_1304.field_6171).method_7960()) {
                if (this.minecraft.field_1690.field_1829 == class_1306.field_6183) {
                    leftOffset -= 20;
                } else {
                    rightOffset += 20;
                }
            }
            this.renderItems(mainWindow.method_4486() / 2 + leftOffset, mainWindow.method_4502() - 32 - 2, true, RenderPos.left, armorSize.width, helmet);
            this.renderItems(mainWindow.method_4486() / 2 + leftOffset, mainWindow.method_4502() - 16 - 2, true, RenderPos.left, armorSize.width, chestplate);
            this.renderItems(mainWindow.method_4486() / 2 + rightOffset, mainWindow.method_4502() - 32 - 2, true, RenderPos.right, armorSize.width, leggings);
            this.renderItems(mainWindow.method_4486() / 2 + rightOffset, mainWindow.method_4502() - 16 - 2, true, RenderPos.right, armorSize.width, boots);
            xposTools = ConfigurationHandler.getCorner().isRight() ? (xposTools += armorSize.width) : (xposTools -= armorSize.width);
        } else {
            this.renderItems(xposArmor, ypos, true, ConfigurationHandler.getCorner().isLeft() ? RenderPos.left : RenderPos.right, armorSize.width, helmet, chestplate, leggings, boots);
        }
        this.renderItems(xposTools, ypos, true, ConfigurationHandler.getCorner().isRight() ? RenderPos.right : RenderPos.left, toolsSize.width, invSlots, mainHand, offHand, arrows);
        this.renderItems(xposTrinkets, ypos, true, ConfigurationHandler.getCorner().isRight() ? RenderPos.right : RenderPos.left, trinketsSize.width, trinkets);
        if (ConfigurationHandler.showEffectDuration()) {
            Collection collection = this.minecraft.field_1724.method_6026();
            int posGood = 0;
            int posBad = 0;
            for (class_1293 potioneffect : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
                if (!potioneffect.method_5592()) continue;
                class_1291 potion = potioneffect.method_5579();
                int xpos = mainWindow.method_4486();
                if (potion.method_5573()) {
                    xpos -= (posGood += 25);
                    ypos = 15;
                } else {
                    xpos -= (posBad += 25);
                    ypos = 41;
                }
                int duration = potioneffect.method_5584();
                String show = duration > 1200 ? duration / 1200 + "m" : duration / 20 + "s";
                this.fontRenderer.method_1729(show, (float)(xpos + 2), (float)ypos, ItemIndicator.color_yellow);
            }
        }
    }

    private RenderSize renderItems(int xpos, int ypos, boolean reallyDraw, RenderPos numberPos, int maxWidth, ItemIndicator ... items) {
        RenderSize result = new RenderSize(0, 0);
        for (ItemIndicator item : items) {
            if (item == null || item.isEmpty() || !item.isItemStackDamageable()) continue;
            String displayString = item.getDisplayValue();
            int width = this.fontRenderer.method_1727(displayString);
            if (width > result.width) {
                result.width = width;
            }
            if (reallyDraw) {
                int color = item.getDisplayColor();
                this.itemRenderer.method_4010(item.getItemStack(), numberPos == RenderPos.left ? xpos + maxWidth - 16 - 2 : xpos, ypos + result.height);
                float f = numberPos != RenderPos.right ? (float)xpos : (float)(xpos + 16 + 2);
                int n = ypos + result.height;
                this.fontRenderer.getClass();
                this.fontRenderer.method_1729(displayString, f, (float)(n + 9 / 2 + (numberPos == RenderPos.over ? 10 : 0)), color);
            }
            result.height += 16;
        }
        if (result.width != 0) {
            result.width += 20;
        }
        return result;
    }

    static {
        haveTrinketsApi = false;
    }

    private static enum RenderPos {
        left,
        over,
        right;

    }

    private class RenderSize {
        int width;
        int height;

        RenderSize(int w, int h) {
            this.width = w;
            this.height = h;
        }
    }
}

