/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.findercompass.client;

import atomicstryker.findercompass.client.FinderCompassClientTicker;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadCompassWorker
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger();
    private cft mcinstance;
    private boolean isRunning = false;
    private blc blockState;
    private int playerX;
    private int playerY;
    private int playerZ;
    private int xzRange;
    private int yRange;
    private int minY;
    private int maxY;

    public ThreadCompassWorker(cft mc) {
        this.mcinstance = mc;
    }

    public void setupValues(blc b, int pX, int pY, int pZ, int xzR, int yR, int mnY, int mxY) {
        this.blockState = b;
        this.playerX = pX;
        this.playerY = pY;
        this.playerZ = pZ;
        this.xzRange = xzR;
        this.yRange = yR;
        this.minY = mnY;
        this.maxY = mxY;
    }

    public boolean isWorking() {
        return this.isRunning;
    }

    @Override
    public void run() {
        this.isRunning = true;
        LOGGER.debug("compass worker started search for blockstate {} from player pos {}", (Object)this.blockState, (Object)new el(this.playerX, this.playerY, this.playerZ));
        el result = this.findNearestBlockChunkOfIDInRange();
        if (result != null) {
            FinderCompassClientTicker.instance.onFoundChunkCoordinates(result, this.blockState);
        }
        this.isRunning = false;
    }

    private el findNearestBlockChunkOfIDInRange() {
        List<el> blocksInRange = this.findBlocksOfIDInRange();
        el playerCoords = new el(this.playerX, this.playerY, this.playerZ);
        el resultCoords = new el(0, 0, 0);
        double minDist = 9999.0;
        for (el coords : blocksInRange) {
            double localDist = playerCoords.n((ff)coords);
            if (!(localDist < minDist)) continue;
            resultCoords = coords;
            minDist = localDist;
            LOGGER.debug("Compassworker found stuff for block {} at coords {}, player distance {}", (Object)this.blockState.c(), (Object)coords, (Object)minDist);
        }
        return resultCoords;
    }

    private List<el> findBlocksOfIDInRange() {
        ArrayList<el> resultList = new ArrayList<el>();
        int counter = 0;
        for (int yIter = this.playerY - this.yRange; yIter <= this.playerY + this.yRange + 1; ++yIter) {
            if (yIter >= this.minY && yIter <= this.maxY) {
                for (int zIter = this.playerZ - this.xzRange; zIter <= this.playerZ + this.xzRange; ++zIter) {
                    for (int xIter = this.playerX - this.xzRange; xIter <= this.playerX + this.xzRange; ++xIter) {
                        blc state = this.mcinstance.g.a_(new el(xIter, yIter, zIter));
                        ++counter;
                        if (state.c() == this.blockState.c()) {
                            resultList.add(new el(xIter, yIter, zIter));
                            LOGGER.trace("block match at {}! state match: {}", (Object)new el(xIter, yIter, zIter), (Object)(state == this.blockState ? 1 : 0));
                        }
                        Thread.yield();
                    }
                }
                continue;
            }
            LOGGER.debug("minY {} maxY {} yIter {} check failed, skipping", (Object)this.minY, (Object)this.maxY, (Object)yIter);
        }
        return resultList;
    }
}

