/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.findercompass.common;

import atomicstryker.findercompass.client.CompassSetting;
import atomicstryker.findercompass.common.CompassConfig;
import atomicstryker.findercompass.common.CompassTargetData;
import atomicstryker.findercompass.common.GsonConfig;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.rift.listener.BootstrapListener;

public class FinderCompassMod
implements BootstrapListener {
    private static final Logger LOGGER = LogManager.getLogger();
    public static FinderCompassMod instance;
    public ArrayList<CompassSetting> settingList;

    public FinderCompassMod() {
        instance = this;
    }

    public void afterVanillaBootstrap() {
        CompassConfig compassConfig = this.createDefaultConfig();
        try {
            GsonConfig.loadConfigWithDefault(CompassConfig.class, new File(cft.s().w, "\\config\\findercompass.cfg"), compassConfig);
            this.settingList = new ArrayList();
            for (CompassConfig.NeedleSet needleSet : compassConfig.getNeedles()) {
                CompassSetting setting = new CompassSetting(needleSet.getName());
                for (Map.Entry<String, int[]> blockEntry : needleSet.getNeedles().entrySet()) {
                    blc state = this.getBlockStateFromString(blockEntry.getKey());
                    if (state != null) {
                        CompassTargetData data = new CompassTargetData(state);
                        setting.getCustomNeedles().put(data, blockEntry.getValue());
                        setting.setHasStrongholdNeedle(false);
                        LOGGER.info("{}: parsed blockstate {} for colors {}", (Object)needleSet.getName(), (Object)state, (Object)blockEntry.getValue());
                        continue;
                    }
                    LOGGER.error("Could not identify block for input {}", (Object)blockEntry.getKey());
                }
                this.settingList.add(setting);
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException parsing config", (Throwable)e);
        }
    }

    private String getStringFromBlockState(blc blockState) {
        HashMap<String, String> blockMap = new HashMap<String, String>();
        blockMap.put("block", fc.g.b((Object)blockState.c()).toString());
        for (bmm property : blockState.c().o().d()) {
            blockMap.put(property.a(), blockState.c(property).toString());
        }
        Gson gson = new Gson();
        return gson.toJson(blockMap);
    }

    private blc getBlockStateFromString(String json) {
        Gson gson = new Gson();
        Map blockMap = (Map)gson.fromJson(json, HashMap.class);
        String resourceAsString = (String)blockMap.get("block");
        bcs block = (bcs)fc.g.b(new pc(resourceAsString));
        if (block == null) {
            return null;
        }
        blc reconstructedState = block.p();
        for (bmm property : block.o().d()) {
            reconstructedState = this.setValueHelper(reconstructedState, property, property.a(), (String)blockMap.get(property.a()));
        }
        return reconstructedState;
    }

    private <S extends blf<S>, T extends Comparable<T>> S setValueHelper(S blockState, bmm<T> property, String propertyName, String valueString) {
        Optional optional = property.b(valueString);
        if (optional.isPresent()) {
            return (S)((blf)blockState.a(property, (Comparable)optional.get()));
        }
        LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", (Object)propertyName, (Object)valueString, (Object)blockState.toString());
        return blockState;
    }

    private CompassConfig createDefaultConfig() {
        CompassConfig compassConfig = new CompassConfig();
        ArrayList<CompassConfig.NeedleSet> needleSetList = new ArrayList<CompassConfig.NeedleSet>();
        CompassConfig.NeedleSet workingManMineables = new CompassConfig.NeedleSet();
        workingManMineables.setName("Working Man's Mineables");
        HashMap<String, Object> needleMap = new HashMap<String, int[]>();
        blc state = bct.G.p();
        String string = this.getStringFromBlockState(state);
        int[] setting = new int[]{245, 245, 0, 15, 1, 1, 100, 0};
        needleMap.put(string, setting);
        state = bct.H.p();
        string = this.getStringFromBlockState(state);
        setting = new int[]{245, 245, 0, 15, 1, 1, 100, 0};
        needleMap.put(string, setting);
        state = bct.I.p();
        string = this.getStringFromBlockState(state);
        setting = new int[]{51, 26, 0, 15, 1, 1, 100, 0};
        needleMap.put(string, setting);
        workingManMineables.setNeedles(needleMap);
        needleSetList.add(workingManMineables);
        CompassConfig.NeedleSet shinyStones = new CompassConfig.NeedleSet();
        shinyStones.setName("Shiny Stones");
        needleMap = new HashMap();
        state = bct.cm.p();
        string = this.getStringFromBlockState(state);
        setting = new int[]{51, 255, 204, 15, 1, 1, 16, 0};
        needleMap.put(string, setting);
        state = bct.aq.p();
        string = this.getStringFromBlockState(state);
        setting = new int[]{55, 70, 220, 15, 1, 1, 100, 0};
        needleMap.put(string, setting);
        state = bct.cM.p();
        string = this.getStringFromBlockState(state);
        setting = new int[]{255, 125, 155, 15, 1, 1, 100, 0};
        needleMap.put(string, setting);
        state = bct.el.p();
        string = this.getStringFromBlockState(state);
        setting = new int[]{26, 255, 26, 7, 1, 4, 31, 0};
        needleMap.put(string, setting);
        shinyStones.setNeedles(needleMap);
        needleSetList.add(shinyStones);
        compassConfig.setNeedles(needleSetList);
        return compassConfig;
    }
}

