/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.findercompass.common;

import atomicstryker.findercompass.client.CompassSetting;
import atomicstryker.findercompass.client.FinderCompassClient;
import atomicstryker.findercompass.client.FinderCompassClientTicker;
import atomicstryker.findercompass.common.CompassConfig;
import atomicstryker.findercompass.common.CompassTargetData;
import atomicstryker.findercompass.common.FinderCompassServer;
import atomicstryker.findercompass.common.GsonConfig;
import atomicstryker.findercompass.common.ISidedProxy;
import atomicstryker.findercompass.common.network.FeatureSearchPacket;
import atomicstryker.findercompass.common.network.HandshakePacket;
import atomicstryker.findercompass.common.network.NetworkHelper;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.IStateHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="findercompass")
@Mod.EventBusSubscriber(modid="findercompass")
public class FinderCompassMod {
    public static final String MOD_ID = "findercompass";
    public static final Logger LOGGER = LogManager.getLogger();
    public static FinderCompassMod instance;
    public static ISidedProxy proxy;
    public CompassConfig compassConfig;
    public ArrayList<CompassSetting> settingList;
    public NetworkHelper networkHelper;

    public FinderCompassMod() {
        instance = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::preInit);
        modEventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.networkHelper = new NetworkHelper(MOD_ID, HandshakePacket.class, FeatureSearchPacket.class);
    }

    public void preInit(FMLCommonSetupEvent evt) {
        this.compassConfig = this.createDefaultConfig();
        try {
            this.compassConfig = GsonConfig.loadConfigWithDefault(CompassConfig.class, new File(proxy.getMcFolder(), File.separator + "config" + File.separator + "findercompass.cfg"), this.compassConfig);
            this.loadSettingListFromConfig(this.compassConfig);
        }
        catch (IOException e) {
            LOGGER.error("IOException parsing config", (Throwable)e);
        }
    }

    public void loadSettingListFromConfig(CompassConfig input) {
        this.compassConfig = input;
        this.settingList = new ArrayList();
        for (CompassConfig.NeedleSet needleSet : this.compassConfig.getNeedles()) {
            CompassSetting setting = new CompassSetting(needleSet.getName(), needleSet.getFeatureNeedle());
            for (Map.Entry<String, int[]> blockEntry : needleSet.getNeedles().entrySet()) {
                BlockState state = this.getBlockStateFromString(blockEntry.getKey());
                if (state != null) {
                    CompassTargetData data = new CompassTargetData(state);
                    setting.getCustomNeedles().put(data, blockEntry.getValue());
                    LOGGER.info("{}: parsed blockstate {} for colors {}", (Object)needleSet.getName(), (Object)state, (Object)blockEntry.getValue());
                    continue;
                }
                LOGGER.error("Could not identify block for input {}", (Object)blockEntry.getKey());
            }
            this.settingList.add(setting);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        this.networkHelper.sendPacketToPlayer(new HandshakePacket("server", GsonConfig.jsonFromConfig(this.compassConfig)), (ServerPlayerEntity)event.getPlayer());
    }

    @SubscribeEvent
    public void clientSetup(TickEvent.ClientTickEvent evt) {
        if (FinderCompassClientTicker.instance == null) {
            FinderCompassClientTicker.instance = new FinderCompassClientTicker();
            FinderCompassClientTicker.instance.onLoad();
            FinderCompassClientTicker.instance.switchSetting();
        }
    }

    private String getStringFromBlockState(BlockState blockState) {
        HashMap<String, String> blockMap = new HashMap<String, String>();
        blockMap.put("block", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)blockState.func_177230_c()).toString());
        for (IProperty property : blockState.func_177230_c().func_176194_O().func_177623_d()) {
            blockMap.put(property.func_177701_a(), blockState.func_177229_b(property).toString());
        }
        Gson gson = new Gson();
        return gson.toJson(blockMap);
    }

    private BlockState getBlockStateFromString(String json) {
        Gson gson = new Gson();
        Map blockMap = (Map)gson.fromJson(json, HashMap.class);
        String resourceAsString = (String)blockMap.get("block");
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(resourceAsString));
        if (block == null) {
            return null;
        }
        BlockState reconstructedState = block.func_176223_P();
        for (IProperty property : block.func_176194_O().func_177623_d()) {
            reconstructedState = this.setValueHelper(reconstructedState, property, property.func_177701_a(), (String)blockMap.get(property.func_177701_a()));
        }
        return reconstructedState;
    }

    private <S extends IStateHolder<S>, T extends Comparable<T>> S setValueHelper(S blockState, IProperty<T> property, String propertyName, String valueString) {
        Optional optional = property.func_185929_b(valueString);
        if (optional.isPresent()) {
            return (S)((IStateHolder)blockState.func_206870_a(property, (Comparable)optional.get()));
        }
        LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", (Object)propertyName, (Object)valueString, (Object)blockState.toString());
        return blockState;
    }

    private CompassConfig createDefaultConfig() {
        CompassConfig compassConfig = new CompassConfig();
        ArrayList<CompassConfig.NeedleSet> needleSetList = new ArrayList<CompassConfig.NeedleSet>();
        CompassConfig.NeedleSet workingManMineables = new CompassConfig.NeedleSet();
        workingManMineables.setName("Working Man's Mineables");
        HashMap<String, Object> needleMap = new HashMap<String, int[]>();
        BlockState state = Blocks.field_150352_o.func_176223_P();
        String string = this.getStringFromBlockState(state);
        int[] setting = new int[]{245, 245, 0, 15, 1, 1, 100, 0};
        needleMap.put(string, setting);
        state = Blocks.field_150366_p.func_176223_P();
        string = this.getStringFromBlockState(state);
        setting = new int[]{245, 245, 0, 15, 1, 1, 100, 0};
        needleMap.put(string, setting);
        state = Blocks.field_150365_q.func_176223_P();
        string = this.getStringFromBlockState(state);
        setting = new int[]{51, 26, 0, 15, 1, 1, 100, 0};
        needleMap.put(string, setting);
        workingManMineables.setNeedles(needleMap);
        workingManMineables.setFeatureNeedle("Village");
        needleSetList.add(workingManMineables);
        CompassConfig.NeedleSet shinyStones = new CompassConfig.NeedleSet();
        shinyStones.setName("Shiny Stones");
        needleMap = new HashMap();
        state = Blocks.field_150482_ag.func_176223_P();
        string = this.getStringFromBlockState(state);
        setting = new int[]{51, 255, 204, 15, 1, 1, 16, 0};
        needleMap.put(string, setting);
        state = Blocks.field_150369_x.func_176223_P();
        string = this.getStringFromBlockState(state);
        setting = new int[]{55, 70, 220, 15, 1, 1, 100, 0};
        needleMap.put(string, setting);
        state = Blocks.field_150450_ax.func_176223_P();
        string = this.getStringFromBlockState(state);
        setting = new int[]{255, 125, 155, 15, 1, 1, 100, 0};
        needleMap.put(string, setting);
        state = Blocks.field_150412_bA.func_176223_P();
        string = this.getStringFromBlockState(state);
        setting = new int[]{26, 255, 26, 7, 1, 4, 31, 0};
        needleMap.put(string, setting);
        shinyStones.setNeedles(needleMap);
        shinyStones.setFeatureNeedle("Stronghold");
        needleSetList.add(shinyStones);
        compassConfig.setNeedles(needleSetList);
        return compassConfig;
    }

    static {
        proxy = (ISidedProxy)DistExecutor.runForDist(() -> () -> new FinderCompassClient(), () -> () -> new FinderCompassServer());
    }
}

