/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.findercompass.common.network;

import atomicstryker.findercompass.common.FinderCompassMod;
import atomicstryker.findercompass.common.network.NetworkHelper;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class FeatureSearchPacket
implements NetworkHelper.IPacket {
    public static final int SEARCH_RADIUS = 160;
    private int MAX_STRING_LENGTH = 256;
    private int x;
    private int y;
    private int z;
    private String username;
    private String featureId;

    public FeatureSearchPacket() {
    }

    public FeatureSearchPacket(String user, String id, int a, int b, int c) {
        this.username = user;
        this.featureId = id;
        this.x = a;
        this.y = b;
        this.z = c;
    }

    @Override
    public void encode(Object msg, PacketBuffer packetBuffer) {
        FeatureSearchPacket packet = (FeatureSearchPacket)msg;
        packetBuffer.func_211400_a(packet.username, this.MAX_STRING_LENGTH);
        packetBuffer.func_211400_a(packet.featureId, this.MAX_STRING_LENGTH);
        packetBuffer.writeInt(packet.x);
        packetBuffer.writeInt(packet.y);
        packetBuffer.writeInt(packet.z);
    }

    @Override
    public <MSG> MSG decode(PacketBuffer packetBuffer) {
        return (MSG)new FeatureSearchPacket(packetBuffer.func_150789_c(this.MAX_STRING_LENGTH), packetBuffer.func_150789_c(this.MAX_STRING_LENGTH), packetBuffer.readInt(), packetBuffer.readInt(), packetBuffer.readInt());
    }

    @Override
    public void handle(Object msg, Supplier<NetworkEvent.Context> contextSupplier) {
        FeatureSearchPacket packet = (FeatureSearchPacket)msg;
        FinderCompassMod.proxy.onReceivedSearchPacket(packet);
        contextSupplier.get().setPacketHandled(true);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String getUsername() {
        return this.username;
    }

    public String getFeatureId() {
        return this.featureId;
    }
}

