/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.findercompass.common.network;

import atomicstryker.findercompass.common.FinderCompassMod;
import atomicstryker.findercompass.common.GsonConfig;
import atomicstryker.findercompass.common.network.NetworkHelper;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class HandshakePacket
implements NetworkHelper.IPacket {
    private int MAX_STRING_LENGTH = 0x7FFFFFFE;
    private String username;
    private String json;

    public HandshakePacket() {
    }

    public HandshakePacket(String user, String json) {
        this.username = user;
        this.json = json;
    }

    public String getUsername() {
        return this.username;
    }

    public String getJson() {
        return this.json;
    }

    @Override
    public void encode(Object msg, PacketBuffer packetBuffer) {
        HandshakePacket packet = (HandshakePacket)msg;
        packetBuffer.func_211400_a(packet.username, this.MAX_STRING_LENGTH);
        if (packet.username.equals("server")) {
            packet.json = GsonConfig.jsonFromConfig(FinderCompassMod.instance.compassConfig);
            packetBuffer.func_211400_a(packet.json, this.MAX_STRING_LENGTH);
        }
    }

    @Override
    public <MSG> MSG decode(PacketBuffer packetBuffer) {
        HandshakePacket packet = new HandshakePacket(packetBuffer.func_150789_c(this.MAX_STRING_LENGTH), packetBuffer.func_150789_c(this.MAX_STRING_LENGTH));
        return (MSG)packet;
    }

    @Override
    public void handle(Object msg, Supplier<NetworkEvent.Context> contextSupplier) {
        HandshakePacket handShakePacket = (HandshakePacket)msg;
        FinderCompassMod.proxy.onReceivedHandshakePacket(handShakePacket);
        contextSupplier.get().setPacketHandled(true);
    }
}

