/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.findercompass.client;

import atomicstryker.findercompass.client.CompassSetting;
import atomicstryker.findercompass.client.FinderCompassLogic;
import atomicstryker.findercompass.common.CompassConfig;
import atomicstryker.findercompass.common.CompassTargetData;
import atomicstryker.findercompass.common.FinderCompassMod;
import atomicstryker.findercompass.common.GsonConfig;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FinderCompassClientTicker {
    public static FinderCompassClientTicker instance;
    private Minecraft mc;
    public FinderCompassLogic compassLogic;
    private CompassSetting currentSetting;
    private Item COMPASS_ITEM_ID;
    private boolean repeat;

    public FinderCompassClientTicker() {
        instance = this;
        this.repeat = false;
        this.currentSetting = null;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void playerLoginToServer(ClientPlayerNetworkEvent.LoggedInEvent evt) {
        FinderCompassMod.instance.initIfNeeded();
    }

    public void onLoad() {
        this.COMPASS_ITEM_ID = Items.field_151111_aL;
        this.mc = Minecraft.func_71410_x();
        ItemModelMesher mesher = this.mc.func_175599_af().func_175037_a();
        mesher.func_199311_a(this.COMPASS_ITEM_ID, new ModelResourceLocation("compass", "inventory"));
        this.compassLogic = new FinderCompassLogic(this.mc);
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent tick) {
        if (tick.phase == TickEvent.Phase.END && this.compassLogic != null) {
            if (tick.player.func_184614_ca().func_77973_b() == this.COMPASS_ITEM_ID) {
                if (this.mc.field_71474_y.field_74312_F.func_151470_d()) {
                    if (!this.repeat) {
                        this.repeat = true;
                        this.switchSetting();
                        tick.player.field_70170_p.func_184133_a(null, new BlockPos(tick.player.func_213303_ch()), SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 0.6f);
                    }
                } else {
                    this.repeat = false;
                }
            }
            this.compassLogic.onTick();
        }
    }

    public CompassSetting getCurrentSetting() {
        return this.currentSetting;
    }

    public void switchSetting() {
        int nextIndex;
        if (this.getSettingsList().isEmpty()) {
            return;
        }
        if (this.currentSetting == null) {
            nextIndex = 0;
        } else {
            this.currentSetting.onDisableThisConfig();
            nextIndex = this.getSettingsList().indexOf(this.currentSetting) + 1;
            if (nextIndex >= this.getSettingsList().size()) {
                nextIndex = 0;
            }
        }
        this.currentSetting = this.getSettingsList().get(nextIndex);
        FinderCompassLogic.hasFeature = false;
        if (this.mc.field_71441_e != null) {
            this.mc.field_71441_e.func_184133_a(null, new BlockPos(this.mc.field_71439_g.func_213303_ch()), SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 0.6f);
            this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TranslationTextComponent("Finder Compass Mode: " + this.currentSetting.getName()));
        }
    }

    public void inputOverrideConfig(String json) {
        this.getSettingsList().clear();
        FinderCompassMod.LOGGER.info("inputting Finder Compass config from serverside: {}", (Object)json);
        CompassConfig compassConfig = GsonConfig.loadConfigFromString(CompassConfig.class, json);
        FinderCompassMod.instance.loadSettingListFromConfig(compassConfig);
        this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TranslationTextComponent("Finder Compass server config loaded; " + this.getSettingsList().size() + " custom Setting-Sets loaded"));
    }

    public void onFoundChunkCoordinates(BlockPos input, BlockState blockState) {
        CompassTargetData key = new CompassTargetData(blockState);
        this.currentSetting.getNewFoundTargets().put(key, input);
    }

    private ArrayList<CompassSetting> getSettingsList() {
        return FinderCompassMod.instance.settingList;
    }
}

