/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture;

import com.mrcrayfish.furniture.api.IRecipeRegistry;
import com.mrcrayfish.furniture.api.RecipeRegistry;
import com.mrcrayfish.furniture.api.RecipeRegistryComm;
import com.mrcrayfish.furniture.api.Recipes;
import com.mrcrayfish.furniture.blocks.tv.Channels;
import com.mrcrayfish.furniture.entity.EntityMirror;
import com.mrcrayfish.furniture.entity.EntitySittableBlock;
import com.mrcrayfish.furniture.gui.GuiHandler;
import com.mrcrayfish.furniture.handler.ConfigurationHandler;
import com.mrcrayfish.furniture.handler.CraftingHandler;
import com.mrcrayfish.furniture.handler.GuiDrawHandler;
import com.mrcrayfish.furniture.handler.InputHandler;
import com.mrcrayfish.furniture.handler.PlayerEvents;
import com.mrcrayfish.furniture.handler.SyncEvent;
import com.mrcrayfish.furniture.init.FurnitureAchievements;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.init.FurnitureCrafting;
import com.mrcrayfish.furniture.init.FurnitureItems;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import com.mrcrayfish.furniture.init.FurnitureTab;
import com.mrcrayfish.furniture.init.FurnitureTileEntities;
import com.mrcrayfish.furniture.network.PacketHandler;
import com.mrcrayfish.furniture.proxy.CommonProxy;
import com.mrcrayfish.furniture.render.tileentity.MirrorRenderer;
import java.lang.reflect.Method;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="cfm", name="MrCrayfish's Furniture Mod", version="4.1.3", guiFactory="com.mrcrayfish.furniture.gui.GuiFactory", acceptedMinecraftVersions="[1.11,1.11.2]")
public class MrCrayfishFurnitureMod {
    @Mod.Instance(value="cfm")
    public static MrCrayfishFurnitureMod instance;
    @SidedProxy(clientSide="com.mrcrayfish.furniture.proxy.ClientProxy", serverSide="com.mrcrayfish.furniture.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs tabFurniture;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ConfigurationHandler());
        FurnitureBlocks.init();
        FurnitureItems.init();
        FurnitureBlocks.register();
        FurnitureItems.registerItems();
        FurnitureSounds.register();
        FurnitureAchievements.loadAchievements();
        FurnitureAchievements.registerPage();
        PacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new CraftingHandler());
        if (event.getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new InputHandler());
            MinecraftForge.EVENT_BUS.register((Object)new GuiDrawHandler());
        } else {
            MinecraftForge.EVENT_BUS.register((Object)new SyncEvent());
        }
        ConfigurationHandler.init(event.getSuggestedConfigurationFile());
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new MirrorRenderer());
        }
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEvents());
        proxy.registerRenders();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        FurnitureTileEntities.register();
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("cfm:mountable_block"), EntitySittableBlock.class, (String)"MountableBlock", (int)0, (Object)this, (int)80, (int)1, (boolean)false);
        if (event.getSide() == Side.CLIENT) {
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("cfm:mirror"), EntityMirror.class, (String)"Mirror", (int)1, (Object)this, (int)80, (int)1, (boolean)false);
        }
        FurnitureCrafting.register();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        RecipeRegistry.registerDefaultRecipes();
        RecipeRegistry.registerConfigRecipes();
        Recipes.addCommRecipesToLocal();
        Recipes.updateDataList();
        Channels.registerChannels(5);
    }

    @Mod.EventHandler
    public void processIMC(FMLInterModComms.IMCEvent event) {
        if (event.getMessages().size() > 0 && ConfigurationHandler.api_debug) {
            System.out.println("RecipeAPI (InterModComm): Registering recipes from " + event.getMessages().size() + " mod(s).");
        }
        for (FMLInterModComms.IMCMessage imcMessage : event.getMessages()) {
            if (!imcMessage.isStringMessage() || !imcMessage.key.equalsIgnoreCase("register")) continue;
            this.register(imcMessage.getStringValue(), imcMessage.getSender());
        }
    }

    public void register(String method, String modid) {
        String[] data = method.split("\\.");
        String methodName = data[data.length - 1];
        String className = method.substring(0, method.length() - methodName.length() - 1);
        String modName = ((ModContainer)Loader.instance().getIndexedModList().get(modid)).getName();
        try {
            Class<?> clazz = Class.forName(className);
            Method registerMethod = clazz.getDeclaredMethod(methodName, IRecipeRegistry.class);
            registerMethod.invoke(null, RecipeRegistryComm.getInstance(modName));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        tabFurniture = new FurnitureTab("tabFurniture");
    }
}

