/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import com.mrcrayfish.furniture.util.CollisionHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockDivingboard
extends BlockFurniture {
    public final int MAX_JUMP_HEIGHT = 4;
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8125, 1.0);
    private static final AxisAlignedBB HANDLE_LEFT_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.0, 0.0, 0.875, 1.0, 0.09375);
    private static final AxisAlignedBB HANDLE_LEFT_EAST = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.0, 0.0, 0.875, 1.0, 0.09375);
    private static final AxisAlignedBB HANDLE_LEFT_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.0, 0.0, 0.875, 1.0, 0.09375);
    private static final AxisAlignedBB HANDLE_LEFT_WEST = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.0, 0.0, 0.875, 1.0, 0.09375);
    private static final AxisAlignedBB[] HANDLE_LEFT = new AxisAlignedBB[]{HANDLE_LEFT_SOUTH, HANDLE_LEFT_WEST, HANDLE_LEFT_NORTH, HANDLE_LEFT_EAST};
    private static final AxisAlignedBB HANDLE_RIGHT_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.0, 0.90625, 0.875, 1.0, 1.0);
    private static final AxisAlignedBB HANDLE_RIGHT_EAST = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.0, 0.90625, 0.875, 1.0, 1.0);
    private static final AxisAlignedBB HANDLE_RIGHT_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.0, 0.90625, 0.875, 1.0, 1.0);
    private static final AxisAlignedBB HANDLE_RIGHT_WEST = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.0, 0.90625, 0.875, 1.0, 1.0);
    private static final AxisAlignedBB[] HANDLE_RIGHT = new AxisAlignedBB[]{HANDLE_RIGHT_SOUTH, HANDLE_RIGHT_WEST, HANDLE_RIGHT_NORTH, HANDLE_RIGHT_EAST};
    private static final AxisAlignedBB BOARD_ONE = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.25, 0.125, 1.0, 0.375, 0.875);
    private static final AxisAlignedBB BOARD_TWO = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.0, 0.25, 0.125, 1.0, 0.375, 0.875);
    private static final AxisAlignedBB[] BOARD = new AxisAlignedBB[]{BOARD_ONE, BOARD_TWO};

    public BlockDivingboard(Material material, boolean plank) {
        super(material);
        this.func_149711_c(1.0f);
        if (plank) {
            this.func_149647_a(null);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (this == FurnitureBlocks.divingboard_base) {
            world.func_175656_a(pos.func_177972_a(placer.func_174811_aO()), FurnitureBlocks.divingboard_plank.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockFurniture.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOARD[facing.func_176736_b() % 2]);
        if (this == FurnitureBlocks.divingboard_base) {
            BlockFurniture.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)HANDLE_LEFT[facing.func_176736_b()]);
            BlockFurniture.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)HANDLE_RIGHT[facing.func_176736_b()]);
        }
    }

    public void func_176216_a(World worldIn, Entity entityIn) {
        if (this == FurnitureBlocks.divingboard_base) {
            super.func_176216_a(worldIn, entityIn);
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (this == FurnitureBlocks.divingboard_plank && entityIn instanceof EntityLivingBase) {
            float height = entityIn.field_70143_R;
            if (height > 0.0f && !entityIn.func_70093_af()) {
                if (height > 4.0f) {
                    height = 4.0f;
                }
                entityIn.field_70181_x = 0.0;
                entityIn.func_70024_g(0.0, this.getRequiredVelocity(height + 1.0f), 0.0);
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, FurnitureSounds.boing, SoundCategory.BLOCKS, 0.75f, 0.75f, false);
                if (worldIn.field_72995_K) {
                    for (int i = 0; i < 3; ++i) {
                        double offsetX = -0.1 + 0.2 * RANDOM.nextDouble();
                        double offsetZ = -0.1 + 0.2 * RANDOM.nextDouble();
                        worldIn.func_175688_a(EnumParticleTypes.SPELL_MOB, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, 1.0, 1.0, 1.0, new int[]{0});
                    }
                }
            }
            entityIn.field_70143_R = 0.0f;
        }
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return true;
    }

    public double getRequiredVelocity(float height) {
        return Math.sqrt(0.22 * (double)height);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (this == FurnitureBlocks.divingboard_base) {
            worldIn.func_175655_b(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)), false);
        } else {
            worldIn.func_175655_b(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d()), false);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return new ItemStack(FurnitureBlocks.divingboard_base).func_77973_b();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(FurnitureBlocks.divingboard_base);
    }
}

