/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFireAlarm
extends BlockFurniture {
    private boolean on = false;
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.3125, 0.875, 0.3125, 0.6875, 1.0, 0.6875);

    public BlockFireAlarm(Material material, boolean on) {
        super(material);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.on = on;
        if (on) {
            this.func_149715_a(1.0f);
            this.func_149647_a(null);
        } else {
            this.func_149715_a(0.2f);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.on) {
            worldIn.func_180501_a(pos, FurnitureBlocks.fire_alarm_off.func_176223_P(), 2);
        }
        return true;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN && this == FurnitureBlocks.fire_alarm_on ? 15 : 0;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.on) {
            int radius = 9;
            block0: for (int x = 0; x < radius; ++x) {
                for (int y = 0; y < radius; ++y) {
                    for (int z = 0; z < radius; ++z) {
                        if (world.func_180495_p(pos.func_177982_a(-4 + x, -4 + y, -4 + z)).func_177230_c() == Blocks.field_150480_ab) {
                            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, FurnitureSounds.fire_alarm, SoundCategory.BLOCKS, 5.0f, 1.0f, false);
                            world.func_180501_a(pos, FurnitureBlocks.fire_alarm_on.func_176223_P(), 2);
                            break block0;
                        }
                        if (x != 8 || y != 8 || z != 8) continue;
                        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
                        break block0;
                    }
                }
            }
        }
        if (this.on) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, FurnitureSounds.fire_alarm, SoundCategory.BLOCKS, 5.0f, 1.0f, false);
            world.func_175684_a(pos, (Block)this, 34);
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (this.on) {
            world.func_175684_a(pos, (Block)this, 34);
        }
        if (!this.on) {
            world.func_175684_a(pos, (Block)this, 1);
        }
        world.func_175685_c(pos, (Block)this, true);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public boolean canBlockStay(World par1World, BlockPos pos) {
        return !par1World.func_175623_d(pos.func_177984_a());
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return new ItemStack(FurnitureBlocks.fire_alarm_off).func_77973_b();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(FurnitureBlocks.fire_alarm_off);
    }
}

