/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.blocks.BlockFurnitureTile;
import com.mrcrayfish.furniture.init.FurnitureAchievements;
import com.mrcrayfish.furniture.init.FurnitureItems;
import com.mrcrayfish.furniture.tileentity.TileEntityMailBox;
import com.mrcrayfish.furniture.util.TileEntityUtil;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMailBox
extends BlockFurnitureTile {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.1625, 0.8125);

    public BlockMailBox(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)placer;
            player.func_71029_a((StatBase)FurnitureAchievements.mailBox);
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("Now right click the mailbox to claim ownership"));
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile_entity = worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K && tile_entity instanceof TileEntityMailBox) {
            TileEntityMailBox tileEntityMailBox = (TileEntityMailBox)tile_entity;
            if (!tileEntityMailBox.hasOwner()) {
                tileEntityMailBox.setOwner(playerIn);
                playerIn.func_145747_a((ITextComponent)new TextComponentString("Successfully set the owner of the mail box to " + TextFormatting.YELLOW + playerIn.func_70005_c_()));
                TileEntityUtil.markBlockForUpdate(worldIn, pos);
                return true;
            }
            tileEntityMailBox.tryAndUpdateName(playerIn);
            if (tileEntityMailBox.canOpen(playerIn)) {
                playerIn.openGui((Object)MrCrayfishFurnitureMod.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                playerIn.func_145747_a((ITextComponent)new TextComponentString("This mail box belongs to " + TextFormatting.YELLOW + tileEntityMailBox.getOwner()));
            }
        }
        return true;
    }

    public float func_149638_a(Entity entity) {
        if (entity instanceof EntityCreeper) {
            return 1000.0f;
        }
        return this.field_149781_w / 5.0f;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntityMailBox tileEntityMailBox = (TileEntityMailBox)world.func_175625_s(pos);
        if (tileEntityMailBox != null) {
            if (tileEntityMailBox.canOpen(player) || !tileEntityMailBox.isClaimed() || this.isAuthorized(player)) {
                this.func_180663_b(world, pos, world.func_180495_p(pos));
                world.func_175698_g(pos);
            } else {
                world.func_175656_a(pos, world.func_180495_p(pos));
                if (!world.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You need to be the owner of the mailbox to destroy it."));
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isAuthorized(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d && player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == FurnitureItems.itemHammer;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        BlockFurnitureTile.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOX);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMailBox();
    }

    @Override
    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityMailBox mailbox = (TileEntityMailBox)world.func_175625_s(pos);
        return mailbox.getMailCount() > 0 ? 1 : 0;
    }
}

