/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.gui.containers.ContainerMailBox;
import com.mrcrayfish.furniture.tileentity.TileEntityFurniture;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityMailBox
extends TileEntityFurniture {
    private String ownerUUID = null;
    private String ownerName = "";

    public TileEntityMailBox() {
        super("mail_box", 6);
    }

    public void setOwner(EntityPlayer player) {
        this.ownerUUID = player.func_110124_au().toString();
        this.ownerName = player.func_70005_c_();
        this.func_70296_d();
    }

    public boolean hasOwner() {
        return this.ownerUUID != null;
    }

    public void tryAndUpdateName(EntityPlayer player) {
        if (this.ownerUUID != null && this.ownerUUID.equalsIgnoreCase(player.func_110124_au().toString()) && !this.ownerName.equalsIgnoreCase(player.func_70005_c_())) {
            this.ownerName = player.func_70005_c_();
            this.func_70296_d();
        }
    }

    public int getMailCount() {
        int count = 0;
        for (ItemStack stack : this.inventory) {
            if (stack == ItemStack.field_190927_a) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("OwnerUUID")) {
            this.ownerUUID = tagCompound.func_74779_i("OwnerUUID");
        }
        if (tagCompound.func_74764_b("OwnerName")) {
            this.ownerName = tagCompound.func_74779_i("OwnerName");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.ownerUUID != null) {
            tagCompound.func_74778_a("OwnerUUID", this.ownerUUID.toString());
        }
        if (this.ownerName != null) {
            tagCompound.func_74778_a("OwnerName", this.ownerName);
        }
        return tagCompound;
    }

    public boolean canOpen(EntityPlayer player) {
        return this.ownerUUID != null && this.ownerUUID.equalsIgnoreCase(player.func_110124_au().toString());
    }

    public boolean isClaimed() {
        return this.ownerUUID != null;
    }

    public void addMail(ItemStack stack) {
        for (int i = 0; i < 6; ++i) {
            if (!((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            this.func_70299_a(i, stack);
            this.func_70296_d();
            break;
        }
    }

    public boolean isMailBoxFull() {
        return this.inventory.stream().anyMatch(ItemStack::func_190926_b);
    }

    public String getOwner() {
        if (this.ownerName == null) {
            return "null";
        }
        return this.ownerName;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerMailBox((IInventory)playerInventory, this);
    }
}

