/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.gui.containers.ContainerMicrowave;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import com.mrcrayfish.furniture.tileentity.TileEntityFurniture;
import com.mrcrayfish.furniture.util.ParticleSpawner;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;

public class TileEntityMicrowave
extends TileEntityFurniture
implements ISidedInventory,
ITickable {
    private Random rand = new Random();
    private static final int[] slot = new int[]{0};
    private String customName;
    private boolean cooking = false;
    public int progress = 0;
    private int timer = 0;

    public TileEntityMicrowave() {
        super("microwave", 1);
    }

    public ItemStack getItem() {
        return this.func_70301_a(0);
    }

    public void startCooking() {
        RecipeData data;
        if (!this.func_70301_a(0).func_190926_b() && (data = RecipeAPI.getMicrowaveRecipeFromIngredients(this.func_70301_a(0))) != null) {
            this.cooking = true;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
        }
    }

    public void stopCooking() {
        this.cooking = false;
        this.progress = 0;
        this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
    }

    public boolean isCooking() {
        return this.cooking;
    }

    public void func_73660_a() {
        if (this.cooking) {
            if (this.field_145850_b.field_72995_K) {
                double posX = (double)this.field_174879_c.func_177958_n() + 0.35 + this.rand.nextDouble() / 3.0;
                double posZ = (double)this.field_174879_c.func_177952_p() + 0.35 + this.rand.nextDouble() / 3.0;
                ParticleSpawner.spawnParticle("smoke", posX, (double)this.field_174879_c.func_177956_o() + 0.065, posZ);
            }
            ++this.progress;
            if (this.progress >= 40) {
                RecipeData data;
                if (!this.func_70301_a(0).func_190926_b() && (data = RecipeAPI.getMicrowaveRecipeFromIngredients(this.func_70301_a(0))) != null) {
                    this.func_70299_a(0, data.getOutput().func_77946_l());
                }
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), FurnitureSounds.microwave_finish, SoundCategory.BLOCKS, 0.75f, 1.0f, true);
                }
                this.timer = 0;
                this.progress = 0;
                this.cooking = false;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
            } else {
                if (this.timer == 20) {
                    this.timer = 0;
                }
                if (this.timer == 0) {
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), FurnitureSounds.microwave_running, SoundCategory.BLOCKS, 0.75f, 1.0f, true);
                }
                ++this.timer;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.cooking = tagCompound.func_74767_n("Coooking");
        this.progress = tagCompound.func_74762_e("Progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("Coooking", this.cooking);
        tagCompound.func_74768_a("Progress", this.progress);
        return tagCompound;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189515_b(new NBTTagCompound()));
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return RecipeAPI.getMicrowaveRecipeFromIngredients(stack) != null;
    }

    public int[] func_180463_a(EnumFacing side) {
        return slot;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return RecipeAPI.getMicrowaveRecipeFromIngredients(stack) != null;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return RecipeAPI.getMicrowaveRecipeFromIngredients(stack) == null;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerMicrowave((IInventory)playerInventory, this);
    }
}

