/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.api.Recipes;
import com.mrcrayfish.furniture.gui.containers.ContainerOven;
import com.mrcrayfish.furniture.tileentity.TileEntityFurniture;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityOven
extends TileEntityFurniture
implements ISidedInventory,
ITickable {
    private Random rand = new Random();
    private static final int[] left_slots = new int[]{0, 1, 2, 3};
    private static final int[] right_slots = new int[]{4, 5, 6, 7};
    public int cookTime = 0;
    public int cookingTime = 0;
    public int cookingItem = 0;
    public static final int COOK_TIME = 200;

    public TileEntityOven() {
        super("oven", 8);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.cookTime = tagCompound.func_74765_d("cookTime");
        this.cookingTime = tagCompound.func_74765_d("cookingTime");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74777_a("cookTime", (short)this.cookTime);
        tagCompound.func_74777_a("cookingTime", (short)this.cookingTime);
        return tagCompound;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.cookingTime * par1 / 200;
    }

    public boolean isBurning() {
        return this.cookTime > 0;
    }

    public boolean isCooking() {
        return this.cookingTime > 0;
    }

    public int getCookingItem() {
        return this.cookingItem;
    }

    public void func_73660_a() {
        boolean flag = this.cookingTime > 0;
        this.cookingItem = this.canCook();
        if (this.cookingItem != -1) {
            ++this.cookingTime;
            if (!flag) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
            }
            if (this.cookingTime == 200) {
                this.cookingTime = 0;
                this.cookItems();
            }
            if (this.field_145850_b.field_72995_K) {
                double randX = this.rand.nextDouble();
                double randZ = this.rand.nextDouble();
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.field_174879_c.func_177958_n() + randX, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + randZ, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            this.cookingTime = 0;
        }
        if (flag && this.cookingTime == 0) {
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
        }
    }

    public boolean canCook(int i) {
        if (i < 4 && !this.func_70301_a(i).func_190926_b()) {
            return Recipes.getOvenRecipeFromInput(this.func_70301_a(i)) != null;
        }
        return false;
    }

    private int canCook() {
        boolean hasItem = false;
        int itemNum = -1;
        for (int x = 0; x < 4; ++x) {
            if (this.func_70301_a(x).func_190926_b()) continue;
            hasItem = true;
            itemNum = x;
            break;
        }
        if (hasItem) {
            RecipeData data = Recipes.getOvenRecipeFromInput(this.func_70301_a(itemNum));
            if (data == null) {
                return -1;
            }
            if (this.func_70301_a(itemNum + 4).func_190926_b()) {
                return itemNum;
            }
            if (this.func_70301_a(itemNum + 4).func_77973_b() != data.getOutput().func_77973_b()) {
                return -1;
            }
            if (this.func_70301_a(itemNum + 4).func_190916_E() < this.func_70297_j_() && this.func_70301_a(itemNum + 4).func_190916_E() < this.func_70301_a(itemNum + 4).func_77976_d()) {
                return itemNum;
            }
            if (this.func_70301_a(itemNum + 4).func_190916_E() < data.getOutput().func_77976_d()) {
                return itemNum;
            }
            return -1;
        }
        return -1;
    }

    public void cookItems() {
        int itemNum = this.canCook();
        if (itemNum != -1) {
            RecipeData data = Recipes.getOvenRecipeFromInput(this.func_70301_a(itemNum));
            if (data == null) {
                return;
            }
            if (this.func_70301_a(itemNum + 4).func_190926_b()) {
                this.func_70299_a(itemNum + 4, data.getOutput().func_77946_l());
            } else if (this.func_70301_a(itemNum + 4).func_77973_b() == data.getOutput().func_77973_b() && this.func_70301_a(itemNum + 4).func_77952_i() == data.getOutput().func_77952_i()) {
                this.func_70301_a(itemNum + 4).func_190917_f(data.getOutput().func_77946_l().func_190916_E());
            }
            if (this.func_70301_a(itemNum).func_77973_b().func_77634_r()) {
                this.func_70299_a(itemNum, new ItemStack(this.func_70301_a(itemNum).func_77973_b().func_77668_q()));
            } else {
                this.func_70301_a(itemNum).func_190918_g(1);
            }
            if (this.func_70301_a(itemNum).func_190916_E() <= 0) {
                this.func_70304_b(itemNum);
            }
        }
    }

    public boolean isStackValidForSlot(int par1, ItemStack par2ItemStack) {
        return RecipeAPI.getOvenRecipeFromInput(par2ItemStack) != null;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i <= 8;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? right_slots : left_slots;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.isStackValidForSlot(index, itemStackIn) && index < left_slots.length;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index >= left_slots.length;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerOven((IInventory)playerInventory, this);
    }
}

