/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.gui.inventory.ISimpleInventory;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import com.mrcrayfish.furniture.util.TileEntityUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;

public class TileEntityToaster
extends TileEntity
implements ITickable,
ISimpleInventory {
    public ItemStack[] slots = new ItemStack[2];
    private int toastingTime = 0;
    private boolean toasting = false;

    public boolean addSlice(ItemStack item) {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] != null) continue;
            this.slots[i] = item.func_77946_l();
            return true;
        }
        return false;
    }

    public void removeSlice() {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            if (!this.field_145850_b.field_72995_K) {
                EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.6, (double)this.field_174879_c.func_177952_p() + 0.5, this.slots[i]);
                this.field_145850_b.func_72838_d((Entity)entityItem);
            }
            this.slots[i] = null;
            TileEntityUtil.markBlockForUpdate(this.field_145850_b, this.field_174879_c);
            return;
        }
    }

    public void startToasting() {
        this.toasting = true;
        TileEntityUtil.markBlockForUpdate(this.field_145850_b, this.field_174879_c);
    }

    public boolean isToasting() {
        return this.toasting;
    }

    public ItemStack getSlice(int slot) {
        return this.slots[slot];
    }

    public void func_73660_a() {
        if (this.toasting) {
            if (this.toastingTime == 200) {
                for (int i = 0; i < this.slots.length; ++i) {
                    if (this.slots[i] == null) continue;
                    if (!this.field_145850_b.field_72995_K) {
                        RecipeData data = RecipeAPI.getToasterRecipeFromInput(this.slots[i]);
                        EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.6, (double)this.field_174879_c.func_177952_p() + 0.5, data.getOutput().func_77946_l());
                        this.field_145850_b.func_72838_d((Entity)entityItem);
                    }
                    this.slots[i] = null;
                }
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, FurnitureSounds.toaster_down, SoundCategory.BLOCKS, 0.75f, 1.0f);
                }
                this.toastingTime = 0;
                this.toasting = false;
                TileEntityUtil.markBlockForUpdate(this.field_145850_b, this.field_174879_c);
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
            } else {
                ++this.toastingTime;
            }
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("Items")) {
            NBTTagList tagList = (NBTTagList)tagCompound.func_74781_a("Items");
            this.slots = new ItemStack[2];
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = tagList.func_150305_b(i);
                byte slot = itemTag.func_74771_c("Slot");
                if (slot < 0 || slot >= this.slots.length) continue;
                this.slots[slot] = new ItemStack(itemTag);
            }
        }
        this.toastingTime = tagCompound.func_74762_e("ToastTime");
        this.toasting = tagCompound.func_74767_n("Toasting");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int slot = 0; slot < this.slots.length; ++slot) {
            if (this.slots[slot] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)slot);
            this.slots[slot].func_77955_b(itemTag);
            tagList.func_74742_a((NBTBase)itemTag);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        tagCompound.func_74768_a("ToastTime", this.toastingTime);
        tagCompound.func_74757_a("Toasting", this.toasting);
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189515_b(new NBTTagCompound()));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public ItemStack getItem(int i) {
        return this.slots[i];
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
    }
}

