/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.gui.containers.ContainerWashingMachine;
import com.mrcrayfish.furniture.init.FurnitureItems;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import com.mrcrayfish.furniture.network.PacketHandler;
import com.mrcrayfish.furniture.network.message.MessageUpdateFields;
import com.mrcrayfish.furniture.tileentity.TileEntityFurniture;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityWashingMachine
extends TileEntityFurniture
implements ISidedInventory,
ITickable {
    private static final int[] slots_top = new int[]{0, 1, 2, 3};
    private static final int[] slots_bottom = new int[]{0, 1, 2, 3, 4};
    private static final int[] slots_sides = new int[]{4};
    private boolean washing = false;
    public boolean superMode = false;
    public int progress = 0;
    public int timeRemaining = 0;
    private Random rand = new Random();
    private int timer = 0;

    public TileEntityWashingMachine() {
        super("washing_machine", 5);
    }

    public void startWashing() {
        if (this.canWash()) {
            if (this.timeRemaining == 0) {
                this.superMode = this.func_70301_a(4).func_77973_b() == FurnitureItems.itemSuperSoapyWater;
                this.func_70299_a(4, new ItemStack(this.func_70301_a(4).func_77973_b().func_77668_q()));
                this.timeRemaining = 5000;
            }
            this.washing = true;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
        }
    }

    public void stopWashing() {
        this.progress = 0;
        this.washing = false;
        this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
    }

    public boolean canWash() {
        if (this.func_70301_a(4).func_190926_b() && this.timeRemaining == 0) {
            return false;
        }
        if (!this.func_70301_a(4).func_190926_b() && this.timeRemaining == 0 && this.func_70301_a(4).func_77973_b() != FurnitureItems.itemSoapyWater && this.func_70301_a(4).func_77973_b() != FurnitureItems.itemSuperSoapyWater) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            RecipeData data;
            if (this.func_70301_a(i).func_190926_b() || (data = RecipeAPI.getWashingMachineRecipeFromInput(this.func_70301_a(i))) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isWashing() {
        return this.washing;
    }

    public static boolean isFuel(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() == FurnitureItems.itemSoapyWater) {
            return true;
        }
        return stack.func_77973_b() == FurnitureItems.itemSuperSoapyWater;
    }

    public void func_73660_a() {
        if (this.washing) {
            if (this.field_145850_b.field_72995_K) {
                ++this.progress;
                return;
            }
            if (!this.canWash()) {
                this.washing = false;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
                this.func_70296_d();
                return;
            }
            if (this.canRepair()) {
                for (int i = 0; i < 4; ++i) {
                    if (this.func_70301_a(i).func_190926_b() || this.func_70301_a(i).func_77958_k() - this.func_70301_a(i).func_77952_i() == this.func_70301_a(i).func_77958_k()) continue;
                    this.func_70301_a(i).func_77964_b(this.func_70301_a(i).func_77952_i() - 1);
                }
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageUpdateFields(this, this.field_174879_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0));
                if (this.progress >= 360) {
                    this.progress = 0;
                }
            }
            --this.timeRemaining;
            if (this.timeRemaining <= 0) {
                if (!this.func_70301_a(4).func_190926_b()) {
                    if (this.func_70301_a(4).func_77973_b() == FurnitureItems.itemSoapyWater) {
                        this.superMode = false;
                        this.func_70299_a(4, new ItemStack(FurnitureItems.itemSoapyWater.func_77668_q()));
                        this.timeRemaining = 5000;
                    } else if (this.func_70301_a(4).func_77973_b() == FurnitureItems.itemSuperSoapyWater) {
                        this.superMode = true;
                        this.func_70299_a(4, new ItemStack(FurnitureItems.itemSuperSoapyWater.func_77668_q()));
                        this.timeRemaining = 5000;
                    }
                } else {
                    this.timeRemaining = 0;
                    this.progress = 0;
                    this.washing = false;
                    this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
                }
                this.func_70296_d();
            }
            ++this.progress;
            if (this.timer == 20) {
                this.timer = 0;
            }
            if (this.timer == 0) {
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, FurnitureSounds.washing_machine, SoundCategory.BLOCKS, 0.75f, 1.0f);
            }
            ++this.timer;
        }
    }

    public boolean canRepair() {
        return this.progress % (this.superMode ? 20 : 50) == 0;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.washing = tagCompound.func_74767_n("Washing");
        this.superMode = tagCompound.func_74767_n("SuperMode");
        this.progress = tagCompound.func_74762_e("Progress");
        this.timeRemaining = tagCompound.func_74762_e("Remaining");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("Washing", this.washing);
        tagCompound.func_74757_a("SuperMode", this.superMode);
        tagCompound.func_74768_a("Progress", this.progress);
        tagCompound.func_74768_a("Remaining", this.timeRemaining);
        return tagCompound;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.progress;
            }
            case 1: {
                return this.timeRemaining;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.progress = value;
            }
            case 1: {
                this.timeRemaining = value;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 2;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemArmor) {
            ItemArmor armour = (ItemArmor)stack.func_77973_b();
            return slot == armour.field_77881_a.func_188454_b();
        }
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return slots_top;
        }
        if (side == EnumFacing.DOWN) {
            return slots_bottom;
        }
        return slots_sides;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing side) {
        if (this.func_174893_q_()) {
            return false;
        }
        if (side == EnumFacing.UP) {
            return RecipeAPI.getWashingMachineRecipeFromInput(stack) != null;
        }
        if (side != EnumFacing.DOWN) {
            return TileEntityWashingMachine.isFuel(stack);
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing side) {
        return side == EnumFacing.DOWN && !TileEntityWashingMachine.isFuel(stack) && stack.func_77952_i() == 0 && !this.func_174893_q_();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerWashingMachine((IInventory)playerInventory, this);
    }
}

