/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client.gui.screen.inventory;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.furniture.client.gui.widget.button.IconButton;
import com.mrcrayfish.furniture.inventory.container.CrateContainer;
import com.mrcrayfish.furniture.network.PacketHandler;
import com.mrcrayfish.furniture.network.message.MessageLockCrate;
import java.util.UUID;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CrateScreen
extends ContainerScreen<CrateContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("cfm", "textures/gui/container/crate.png");
    private static final ResourceLocation ICONS_TEXTURE = new ResourceLocation("cfm", "textures/gui/icons.png");
    private IconButton button;
    private boolean locked;

    public CrateScreen(CrateContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
    }

    protected void init() {
        super.init();
        this.button = (IconButton)this.addButton((Widget)new IconButton(this.field_147003_i + this.field_146999_f + 2, this.field_147009_r + 17, I18n.func_135052_a((String)"gui.button.cfm.lock", (Object[])new Object[0]), button -> PacketHandler.instance.sendToServer((Object)new MessageLockCrate()), ICONS_TEXTURE, 0, 0));
        this.updateLockButton();
    }

    public void tick() {
        super.tick();
        if (this.locked != ((CrateContainer)this.field_147002_h).getCrateTileEntity().isLocked()) {
            this.locked = ((CrateContainer)this.field_147002_h).getCrateTileEntity().isLocked();
            this.updateLockButton();
        }
    }

    private void updateLockButton() {
        this.locked = ((CrateContainer)this.field_147002_h).getCrateTileEntity().isLocked();
        this.button.setIcon(ICONS_TEXTURE, this.locked ? 0 : 16, 0);
        this.button.setMessage(I18n.func_135052_a((String)(this.locked ? "gui.button.cfm.locked" : "gui.button.cfm.unlocked"), (Object[])new Object[0]));
        UUID ownerUuid = ((CrateContainer)this.field_147002_h).getCrateTileEntity().getOwner();
        this.button.visible = ownerUuid == null || this.field_213127_e.field_70458_d.func_110124_au().equals(ownerUuid);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (this.button.isMouseOver(mouseX, mouseY)) {
            this.renderTooltip(this.locked ? I18n.func_135052_a((String)"gui.button.cfm.locked", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.button.cfm.unlocked", (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.title.func_150254_d(), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(GUI_TEXTURE);
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        this.blit(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }
}

