/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client.renderer.tileentity;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.tileentity.KitchenSinkTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IEnviromentBlockReader;

public class KitchenSinkTileEntityRenderer
extends TileEntityRenderer<KitchenSinkTileEntity> {
    public void render(KitchenSinkTileEntity tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.disableCull();
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        Direction direction = (Direction)tileEntityIn.func_195044_w().func_177229_b((IProperty)FurnitureHorizontalBlock.DIRECTION);
        GlStateManager.translated((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.rotatef((float)((float)direction.func_176736_b() * -90.0f - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translated((double)-0.5, (double)-0.5, (double)-0.5);
        this.drawFluid(tileEntityIn, 0.125, 0.625, 0.125, 0.625, 0.3125, 0.75);
        GlStateManager.disableBlend();
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
    }

    private void drawFluid(KitchenSinkTileEntity te, double x, double y, double z, double width, double height, double depth) {
        Fluid fluid = te.getTank().getFluid().getFluid();
        if (fluid == Fluids.field_204541_a) {
            return;
        }
        ResourceLocation resource = fluid.getAttributes().getStillTexture();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(resource.toString());
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        double minU = sprite.func_94209_e();
        double maxU = Math.min(minU + ((double)sprite.func_94212_f() - minU) * depth, (double)sprite.func_94212_f());
        double minV = sprite.func_94206_g();
        double maxV = Math.min(minV + ((double)sprite.func_94210_h() - minV) * width, (double)sprite.func_94210_h());
        int light = this.func_178459_a().func_217338_b(te.func_174877_v(), fluid.getAttributes().getLuminosity());
        int lightX = light >> 16 & 0xFFFF;
        int lightY = light & 0xFFFF;
        int waterColor = fluid.getAttributes().getColor((IEnviromentBlockReader)te.func_145831_w(), te.func_174877_v());
        float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(waterColor & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        buffer.func_181662_b(x, y + (height *= (double)te.getTank().getFluidAmount() / (double)te.getTank().getCapacity()), z).func_187315_a(maxU, minV).func_187314_a(lightX, lightY).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buffer.func_181662_b(x, y + height, z + depth).func_187315_a(minU, minV).func_187314_a(lightX, lightY).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buffer.func_181662_b(x + width, y + height, z + depth).func_187315_a(minU, maxV).func_187314_a(lightX, lightY).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buffer.func_181662_b(x + width, y + height, z).func_187315_a(maxU, maxV).func_187314_a(lightX, lightY).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        tessellator.func_78381_a();
    }
}

