/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.block.BedsideCabinetBlock;
import com.mrcrayfish.furniture.core.ModSounds;
import com.mrcrayfish.furniture.core.ModTileEntities;
import com.mrcrayfish.furniture.tileentity.BasicLootTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class BedsideCabinetTileEntity
extends BasicLootTileEntity {
    private int playerCount;

    public BedsideCabinetTileEntity() {
        super(ModTileEntities.BEDSIDE_CABINET);
    }

    @Override
    public int func_70302_i_() {
        return 9;
    }

    @Override
    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.cfm.bedside_cabinet", new Object[0]);
    }

    @Override
    protected Container func_213906_a(int windowId, PlayerInventory playerInventory) {
        return new ChestContainer(ContainerType.field_221507_a, windowId, playerInventory, (IInventory)this, 1);
    }

    public void func_174889_b(PlayerEntity playerEntity) {
        if (!playerEntity.func_175149_v()) {
            if (this.playerCount < 0) {
                this.playerCount = 0;
            }
            ++this.playerCount;
            BlockState blockState = this.func_195044_w();
            boolean open = (Boolean)blockState.func_177229_b((IProperty)BedsideCabinetBlock.OPEN);
            if (!open) {
                this.playDoorSound(blockState, ModSounds.BLOCK_BEDSIDE_CABINET_OPEN);
                this.setDoorState(blockState, true);
            }
            this.scheduleTick();
        }
    }

    public void func_174886_c(PlayerEntity playerEntity) {
        if (!playerEntity.func_175149_v()) {
            --this.playerCount;
        }
    }

    private void scheduleTick() {
        this.field_145850_b.func_205220_G_().func_205360_a(this.func_174877_v(), (Object)this.func_195044_w().func_177230_c(), 5);
    }

    public void onScheduledTick() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        World world = this.func_145831_w();
        if (world != null) {
            this.playerCount = ChestTileEntity.func_213976_a((World)world, (LockableTileEntity)this, (int)x, (int)y, (int)z);
            if (this.playerCount > 0) {
                this.scheduleTick();
            } else {
                BlockState blockState = this.func_195044_w();
                if (!(blockState.func_177230_c() instanceof BedsideCabinetBlock)) {
                    this.func_145843_s();
                    return;
                }
                boolean open = (Boolean)blockState.func_177229_b((IProperty)BedsideCabinetBlock.OPEN);
                if (open) {
                    this.playDoorSound(blockState, ModSounds.BLOCK_BEDSIDE_CABINET_CLOSE);
                    this.setDoorState(blockState, false);
                }
            }
        }
    }

    private void playDoorSound(BlockState blockState, SoundEvent soundEvent) {
        Vec3i directionVec = ((Direction)blockState.func_177229_b((IProperty)BedsideCabinetBlock.DIRECTION)).func_176730_m();
        double x = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)directionVec.func_177958_n() / 2.0;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5 + (double)directionVec.func_177956_o() / 2.0;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)directionVec.func_177952_p() / 2.0;
        World world = this.func_145831_w();
        if (world != null) {
            world.func_184148_a(null, x, y, z, soundEvent, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    private void setDoorState(BlockState blockState, boolean open) {
        World world = this.func_145831_w();
        if (world != null) {
            world.func_180501_a(this.func_174877_v(), (BlockState)blockState.func_206870_a((IProperty)BedsideCabinetBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }
}

