/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.util.TileEntityUtil;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public abstract class FluidHandlerSyncedTileEntity
extends TileEntity {
    protected final FluidTank tank;

    public FluidHandlerSyncedTileEntity(TileEntityType<?> tileEntityTypeIn, int capacity) {
        super(tileEntityTypeIn);
        this.tank = new FluidTank(capacity){

            protected void onContentsChanged() {
                FluidHandlerSyncedTileEntity.this.syncFluidToClient();
            }
        };
    }

    public FluidTank getTank() {
        return this.tank;
    }

    private void syncFluidToClient() {
        TileEntityUtil.sendUpdatePacket(this, this.func_189515_b(new CompoundNBT()));
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.tank.writeToNBT(tag);
        return super.func_189515_b(tag);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tank).cast();
        }
        return super.getCapability(capability, facing);
    }
}

