/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.client.gui;

import com.google.common.collect.Ordering;
import de.guntram.mcmod.durabilityviewer.DurabilityViewer;
import de.guntram.mcmod.durabilityviewer.handler.ConfigurationHandler;
import de.guntram.mcmod.durabilityviewer.itemindicator.InventorySlotsIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemCountIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemDamageIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemIndicator;
import de.guntram.mcmod.durabilityviewer.sound.ItemBreakingWarner;
import java.util.Collection;
import org.lwjgl.glfw.GLFW;

public class GuiItemDurability {
    private final cft minecraft = cft.s();
    private static boolean visible;
    private final cgk fontRenderer;
    private final czg itemRenderer;
    private static final int iconWidth = 16;
    private static final int iconHeight = 16;
    private static final int spacing = 2;
    private ItemBreakingWarner mainHandWarner;
    private ItemBreakingWarner offHandWarner;
    private ItemBreakingWarner helmetWarner;
    private ItemBreakingWarner chestWarner;
    private ItemBreakingWarner pantsWarner;
    private ItemBreakingWarner bootsWarner;

    public static void toggleVisibility() {
        visible = !visible;
    }

    public GuiItemDurability() {
        this.fontRenderer = this.minecraft.l;
        this.itemRenderer = this.minecraft.V();
        visible = true;
        this.mainHandWarner = new ItemBreakingWarner();
        this.offHandWarner = new ItemBreakingWarner();
        this.helmetWarner = new ItemBreakingWarner();
        this.chestWarner = new ItemBreakingWarner();
        this.pantsWarner = new ItemBreakingWarner();
        this.bootsWarner = new ItemBreakingWarner();
    }

    private int getInventoryArrowCount() {
        int arrows = 0;
        for (ate stack : this.minecraft.i.bB.a) {
            if (!this.isArrow(stack)) continue;
            arrows += stack.C();
        }
        return arrows;
    }

    private ate getFirstArrowStack() {
        if (this.isArrow(this.minecraft.i.b(adk.b))) {
            return this.minecraft.i.b(adk.b);
        }
        if (this.isArrow(this.minecraft.i.b(adk.a))) {
            return this.minecraft.i.b(adk.a);
        }
        int size = this.minecraft.i.bB.T_();
        for (int i = 0; i < size; ++i) {
            ate itemstack = this.minecraft.i.bB.a(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    private boolean isArrow(ate stack) {
        return !stack.a() && stack.b() instanceof arf;
    }

    public void onRenderGameOverlayPost(float partialTicks) {
        int ypos;
        int xposTools;
        int xposArmor;
        String newTitle = DurabilityViewer.getAndResetChangedWindowTitle();
        if (newTitle != null) {
            GLFW.glfwSetWindowTitle((long)cft.s().f.j(), (CharSequence)newTitle);
        }
        if (!visible || this.minecraft.i.bV.d) {
            return;
        }
        ctj effectivePlayer = this.minecraft.i;
        boolean needToWarn = false;
        ItemDamageIndicator mainHand = new ItemDamageIndicator(effectivePlayer.b(aew.a));
        ItemDamageIndicator offHand = new ItemDamageIndicator(effectivePlayer.b(aew.b));
        ItemDamageIndicator boots = new ItemDamageIndicator(effectivePlayer.b(aew.c));
        ItemDamageIndicator leggings = new ItemDamageIndicator(effectivePlayer.b(aew.d));
        ItemDamageIndicator chestplate = new ItemDamageIndicator(effectivePlayer.b(aew.e));
        ItemDamageIndicator helmet = new ItemDamageIndicator(effectivePlayer.b(aew.f));
        ItemCountIndicator arrows = null;
        InventorySlotsIndicator invSlots = new InventorySlotsIndicator(this.minecraft.i.bB);
        needToWarn |= this.mainHandWarner.checkBreaks(effectivePlayer.b(aew.a));
        needToWarn |= this.offHandWarner.checkBreaks(effectivePlayer.b(aew.b));
        needToWarn |= this.bootsWarner.checkBreaks(effectivePlayer.b(aew.c));
        needToWarn |= this.pantsWarner.checkBreaks(effectivePlayer.b(aew.d));
        needToWarn |= this.chestWarner.checkBreaks(effectivePlayer.b(aew.e));
        if (needToWarn |= this.helmetWarner.checkBreaks(effectivePlayer.b(aew.f))) {
            ItemBreakingWarner.playWarningSound();
        }
        if (mainHand.getItemStack().b() instanceof arp || offHand.getItemStack().b() instanceof arp) {
            arrows = new ItemCountIndicator(this.getFirstArrowStack(), this.getInventoryArrowCount());
        }
        cgd mainWindow = cft.s().f;
        RenderSize armorSize = this.renderItems(0, 0, false, RenderPos.left, 0, boots, leggings, chestplate, helmet);
        RenderSize toolsSize = this.renderItems(0, 0, false, RenderPos.right, 0, invSlots, mainHand, offHand, arrows);
        int totalHeight = toolsSize.height > armorSize.height ? toolsSize.height : armorSize.height;
        int totalWidth = toolsSize.width > armorSize.width ? toolsSize.width : armorSize.width;
        switch (ConfigurationHandler.getCorner()) {
            case TOP_LEFT: {
                xposArmor = 5;
                xposTools = 5 + armorSize.width;
                ypos = 5;
                break;
            }
            case TOP_RIGHT: {
                xposArmor = mainWindow.p() - 5 - armorSize.width;
                xposTools = mainWindow.p() - 5 - armorSize.width - toolsSize.width;
                ypos = 60;
                break;
            }
            case BOTTOM_LEFT: {
                xposArmor = 5;
                xposTools = 5 + armorSize.width;
                ypos = mainWindow.q() - 5 - totalHeight;
                break;
            }
            case BOTTOM_RIGHT: {
                xposArmor = mainWindow.p() - 5 - armorSize.width;
                xposTools = mainWindow.p() - 5 - armorSize.width - toolsSize.width;
                ypos = mainWindow.q() - 5 - totalHeight;
                break;
            }
            default: {
                return;
            }
        }
        cua.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        cfr.b();
        cfr.c();
        if (ConfigurationHandler.getArmorAroundHotbar()) {
            this.renderItems(mainWindow.p() / 2 - 130, mainWindow.q() - 32 - 2, true, RenderPos.left, armorSize.width, helmet);
            this.renderItems(mainWindow.p() / 2 - 130, mainWindow.q() - 16 - 2, true, RenderPos.left, armorSize.width, chestplate);
            this.renderItems(mainWindow.p() / 2 + 100, mainWindow.q() - 32 - 2, true, RenderPos.right, armorSize.width, leggings);
            this.renderItems(mainWindow.p() / 2 + 100, mainWindow.q() - 16 - 2, true, RenderPos.right, armorSize.width, boots);
            xposTools = ConfigurationHandler.getCorner().isRight() ? (xposTools += armorSize.width) : (xposTools -= armorSize.width);
        } else {
            this.renderItems(xposArmor, ypos, true, ConfigurationHandler.getCorner().isLeft() ? RenderPos.left : RenderPos.right, armorSize.width, helmet, chestplate, leggings, boots);
        }
        this.renderItems(xposTools, ypos, true, ConfigurationHandler.getCorner().isRight() ? RenderPos.right : RenderPos.left, toolsSize.width, invSlots, mainHand, offHand, arrows);
        cfr.a();
        if (ConfigurationHandler.showEffectDuration()) {
            Collection collection = this.minecraft.i.cn();
            int posGood = 0;
            int posBad = 0;
            for (aek potioneffect : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
                if (!potioneffect.e()) continue;
                aej potion = potioneffect.a();
                int xpos = mainWindow.p();
                if (potion.k()) {
                    xpos -= (posGood += 25);
                    ypos = 15;
                } else {
                    xpos -= (posBad += 25);
                    ypos = 41;
                }
                int duration = potioneffect.b();
                String show = duration > 1200 ? duration / 1200 + "m" : duration / 20 + "s";
                this.fontRenderer.b(show, (float)(xpos + 2), (float)ypos, ItemIndicator.color_yellow);
            }
        }
    }

    private RenderSize renderItems(int xpos, int ypos, boolean reallyDraw, RenderPos numberPos, int maxWidth, ItemIndicator ... items) {
        RenderSize result = new RenderSize(0, 0);
        for (ItemIndicator item : items) {
            if (item == null || item.isEmpty() || !item.isItemStackDamageable()) continue;
            String displayString = item.getDisplayValue();
            int width = this.fontRenderer.a(displayString);
            if (width > result.width) {
                result.width = width;
            }
            if (reallyDraw) {
                int color = item.getDisplayColor();
                this.itemRenderer.b(item.getItemStack(), numberPos == RenderPos.left ? xpos + maxWidth - 16 - 2 : xpos, ypos + result.height);
                this.fontRenderer.b(displayString, numberPos != RenderPos.right ? (float)xpos : (float)(xpos + 16 + 2), (float)(ypos + result.height + this.fontRenderer.a / 2 + (numberPos == RenderPos.over ? 10 : 0)), color);
            }
            result.height += 16;
        }
        if (result.width != 0) {
            result.width += 20;
        }
        return result;
    }

    private static enum RenderPos {
        left,
        over,
        right;

    }

    private class RenderSize {
        int width;
        int height;

        RenderSize(int w, int h) {
            this.width = w;
            this.height = h;
        }
    }
}

