/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.rift.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import java.util.concurrent.CompletableFuture;
import org.dimdev.rift.listener.client.LocalCommandAdder;
import org.dimdev.riftloader.RiftLoader;

public class LocalCommandManager {
    private static LocalCommandManager instance;
    private CommandDispatcher<bu> dispatcher;
    private CompletableFuture<Suggestions> suggestions;

    private LocalCommandManager() {
    }

    public static LocalCommandManager getInstance() {
        if (instance == null) {
            instance = new LocalCommandManager();
            LocalCommandManager.instance.dispatcher = new CommandDispatcher();
            for (LocalCommandAdder localCommandAdder : RiftLoader.instance.getListeners(LocalCommandAdder.class)) {
                localCommandAdder.registerLocalCommands(LocalCommandManager.instance.dispatcher);
            }
        }
        return instance;
    }

    public static void dispatchLocalCommand(String s) throws CommandSyntaxException {
        LocalCommandManager.getInstance().dispatcher.execute(s, null);
    }

    private Suggestions getSuggestionsFor(String command) {
        if (!command.startsWith("/")) {
            return null;
        }
        StringReader reader = new StringReader(command);
        reader.skip();
        ParseResults parse = this.dispatcher.parse(reader, null);
        this.suggestions = this.dispatcher.getCompletionSuggestions(parse);
        Suggestions result = this.suggestions.join();
        return result;
    }

    public static Suggestions getSuggestions(String s) {
        return LocalCommandManager.getInstance().getSuggestionsFor(s);
    }
}

