/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.handler;

import de.guntram.mcmod.durabilityviewer.client.gui.Corner;
import java.io.File;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    private static ConfigurationHandler instance;
    private Configuration config;
    private TextFormatting tooltipColor;
    private String configFileName;
    private int corner = 0;
    private int color = 5;

    public static ConfigurationHandler getInstance() {
        if (instance == null) {
            instance = new ConfigurationHandler();
        }
        return instance;
    }

    public void load(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile);
            this.configFileName = configFile.getPath();
            this.loadConfig();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("durabilityviewer")) {
            this.loadConfig();
        }
    }

    private void loadConfig() {
        this.corner = this.config.getInt("HUD Corner", "client", this.corner, 0, 3, "Corner 0 to 3 - bottom right, bottom left, top right, top left");
        this.color = this.config.getInt("Tooltip Color", "client", this.color, 0, 15, "Minecraft Color 0 .. 15");
        this.tooltipColor = TextFormatting.func_175744_a((int)this.color);
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public static TextFormatting getTooltipColor() {
        return ConfigurationHandler.getInstance().tooltipColor;
    }

    public static Corner getCorner() {
        return Corner.values()[ConfigurationHandler.getInstance().corner];
    }

    public static Configuration getConfig() {
        return ConfigurationHandler.getInstance().config;
    }

    public static String getConfigFileName() {
        return ConfigurationHandler.getInstance().configFileName;
    }
}

