/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer;

import de.guntram.mcmod.durabilityviewer.client.gui.GuiItemDurability;
import de.guntram.mcmod.durabilityviewer.event.KeyInputEvent;
import de.guntram.mcmod.durabilityviewer.event.TooltipEvent;
import de.guntram.mcmod.durabilityviewer.handler.ConfigurationHandler;
import de.guntram.mcmod.durabilityviewer.handler.KeyHandler;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="durabilityviewer", name="Durability Viewer", version="1.4", clientSideOnly=true, acceptedMinecraftVersions="[1.12]", guiFactory="de.guntram.mcmod.durabilityviewer.client.gui.DurabilityViewerGuiFactory", dependencies="")
public class DurabilityViewer {
    public static final String MODID = "durabilityviewer";
    public static final String VERSION = "1.4";
    @Mod.Instance(value="durabilityviewer")
    public static DurabilityViewer instance;
    private static ConfigurationHandler confHandler;
    private static String changedWindowTitle;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        confHandler = ConfigurationHandler.getInstance();
        confHandler.load(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        changedWindowTitle = null;
        KeyHandler.init();
        System.out.println("on Init, confHandler is " + confHandler);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)confHandler);
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputEvent());
        MinecraftForge.EVENT_BUS.register((Object)new TooltipEvent());
        MinecraftForge.EVENT_BUS.register((Object)new GuiItemDurability());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onConnectedToServerEvent(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        String serverName;
        if (!ConfigurationHandler.showPlayerServerName()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        String string = serverName = event.isLocal() ? "local game" : mc.func_147104_D().field_78847_a;
        if (serverName == null) {
            serverName = "unknown server";
        }
        changedWindowTitle = mc.func_110432_I().func_111285_a() + " on " + serverName;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDisconnectFromServerEvent(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (!ConfigurationHandler.showPlayerServerName()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        changedWindowTitle = mc.func_110432_I().func_111285_a() + " not connected";
    }

    public static String getAndResetChangedWindowTitle() {
        String result = changedWindowTitle;
        changedWindowTitle = null;
        return result;
    }
}

